/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.util.HashMap;

final class CodepointMappings {
    private boolean m_hasMappings = false;
    private final HashMap m_codepointToString;
    static final int ASCII_MAX = 127;
    private final boolean[] m_ASCIIMapped = new boolean[128];
    private final CodepointKey m_codepointKey;

    public CodepointMappings() {
        this.m_codepointToString = new HashMap();
        this.m_codepointKey = new CodepointKey();
    }

    String getString(int n) {
        if (n <= 127 && !this.m_ASCIIMapped[n]) {
            return null;
        }
        this.m_codepointKey.setKey(n);
        return (String)this.m_codepointToString.get(this.m_codepointKey);
    }

    public void setString(int n, String string) {
        this.m_codepointKey.setKey(n);
        this.m_codepointToString.put(this.m_codepointKey, string);
        if (n <= 127) {
            this.m_ASCIIMapped[n] = true;
        }
        this.m_hasMappings = true;
    }

    public boolean hasMappings() {
        return this.m_hasMappings;
    }

    public void reset() {
        for (int i = 0; i <= 127; ++i) {
            this.m_ASCIIMapped[i] = false;
        }
        this.m_codepointToString.clear();
        this.m_hasMappings = false;
    }

    private static class CodepointKey {
        private int m_codepoint;

        private CodepointKey() {
        }

        private void setKey(int n) {
            this.m_codepoint = n;
        }

        public final int hashCode() {
            return this.m_codepoint;
        }

        public final boolean equals(Object object) {
            return ((CodepointKey)object).m_codepoint == this.m_codepoint;
        }
    }
}

