/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PostOrderOptimizer;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.utils.XylemError;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FindFreeBindings
extends PostOrderOptimizer {
    BindingEnvironment m_benv = new BindingEnvironment();
    private HashSet m_freeBindings = new HashSet();

    protected FindFreeBindings(BindingEnvironment bindingEnvironment) {
        this.m_benv = bindingEnvironment;
    }

    public static Set findFreeBindings(Instruction instruction, BindingEnvironment bindingEnvironment) {
        FindFreeBindings findFreeBindings = new FindFreeBindings(bindingEnvironment);
        findFreeBindings.optimize(instruction);
        return findFreeBindings.getFreeBindings();
    }

    public HashSet getFreeBindings() {
        return this.m_freeBindings;
    }

    @Override
    public Instruction optimize(Instruction instruction) {
        this.m_freeBindings.clear();
        return super.optimize(instruction);
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
        if (instruction instanceof IdentifierInstruction) {
            this.m_freeBindings.add(((IdentifierInstruction)instruction).getBinding(this.m_benv));
        }
        return instruction;
    }

    @Override
    protected void optimizeChildren(Instruction instruction) {
        HashSet hashSet = null;
        int n = instruction.getChildInstructionCount();
        hashSet = n < 2 ? this.m_freeBindings : new HashSet();
        for (int i = 0; i < n; ++i) {
            Instruction instruction2 = instruction.getChildInstruction(i);
            this.optimizeChildren(instruction2);
            Instruction instruction3 = this.optimizeStep(instruction2, instruction, i);
            if (instruction instanceof ISpecialForm && ((ISpecialForm)((Object)instruction)).isChildInstructionBody(i)) {
                IBinding[] iBindingArray = ((ISpecialForm)((Object)instruction)).getChildInstructionBindings(i);
                if (iBindingArray == null) {
                    throw new XylemError("ERR_SYSTEM", "!" + i + " " + instruction);
                }
                this.m_freeBindings.removeAll(Arrays.asList(iBindingArray));
            }
            if (hashSet == this.m_freeBindings) continue;
            hashSet.addAll(this.m_freeBindings);
            this.m_freeBindings.clear();
        }
        this.m_freeBindings = hashSet;
    }
}

