/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.interpreter;

import com.ibm.xylem.Type;
import com.ibm.xylem.interpreter.IConvertible;
import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.interpreter.StreamUtilities;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.JavaObjectType;
import com.ibm.xylem.utils.XylemError;
import java.util.Iterator;

public class StringStream
implements IStream,
IConvertible {
    protected String m_string;

    public StringStream(String string) {
        this.m_string = string;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            int m_i = 0;
            int m_c;
            {
                this.m_c = StringStream.this.m_string.length();
            }

            @Override
            public boolean hasNext() {
                return this.m_i < this.m_c;
            }

            public Object next() {
                return new Character(StringStream.this.m_string.charAt(this.m_i++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String toString() {
        return this.m_string;
    }

    @Override
    public char[] toCharArray() {
        return this.m_string.toCharArray();
    }

    @Override
    public Object convert(Type type) {
        if (type.equals(JavaObjectType.s_javaStringType)) {
            return this.m_string;
        }
        if (type.equals(CharType.s_charType.getStreamType())) {
            return this.toCharArray();
        }
        throw new XylemError("ERR_SYSTEM", "Cannot convert StringStream to " + type);
    }

    @Override
    public int size() {
        return this.m_string.length();
    }

    @Override
    public Object get(int n) {
        return new Character(this.m_string.charAt(n));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IStream)) {
            return false;
        }
        return StreamUtilities.equals(this, (IStream)object);
    }

    public int hashCode() {
        return StreamUtilities.hashCode(this);
    }
}

