/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.IImperativeInstruction;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.OrderedSet;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.RepeatingNameGenerator;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.PureInstruction;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IAppendableStream;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.utils.SourceLocation;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public abstract class Instruction {
    protected static final Logger s_logger = Logger.getInstance(Instruction.class);
    private Type m_cachedType = null;
    protected BindingEnvironment m_bindingEnvironment = null;
    protected boolean m_hasBeenTypechecked = false;
    protected URL m_sourceFilename = null;
    protected int m_sourceLineNumber = -1;
    private SourceLocation m_sourceLocation = null;
    static final INewNameGenerator s_defaultGenerator = new INewNameGenerator(){

        @Override
        public Object getNewName() {
            return ReductionHelper.generateIntermediateIdentifier2();
        }
    };
    static final boolean s_sanityCheck = false;
    boolean typeAliasesExpanded = false;

    public final void setSourceFilename(URL uRL) {
        this.m_sourceFilename = uRL;
    }

    public final void setSourceLineNumber(int n) {
        this.m_sourceLineNumber = n;
    }

    public final URL getSourceFilename() {
        return this.m_sourceFilename;
    }

    public final int getSourceLineNumber() {
        return this.m_sourceLineNumber;
    }

    public final void setSourceLocation(SourceLocation sourceLocation) {
        this.m_sourceLocation = sourceLocation;
    }

    public final SourceLocation getSourceLocation() {
        return this.m_sourceLocation;
    }

    public final boolean hasBeenTypeChecked() {
        return this.m_hasBeenTypechecked;
    }

    public void setBindingEnvironment(BindingEnvironment bindingEnvironment) {
        this.m_bindingEnvironment = bindingEnvironment;
    }

    public abstract Type typeCheck(TypeEnvironment var1, BindingEnvironment var2, LinkedList var3) throws TypeCheckException;

    protected final void doDefaultTypeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        if (this.m_hasBeenTypechecked) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Instruction " + this.getClass() + ":'" + this + "' has already been type checked"), this);
        }
        this.m_bindingEnvironment = bindingEnvironment;
        this.m_hasBeenTypechecked = true;
    }

    public final Type getCachedType() {
        return this.m_cachedType;
    }

    public abstract Type getType(TypeEnvironment var1, BindingEnvironment var2);

    public boolean isPure() {
        if (this instanceof PureInstruction) {
            return true;
        }
        if (this instanceof IImperativeInstruction) {
            return false;
        }
        int n = this.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            Instruction instruction = this.getChildInstruction(i);
            if (instruction.isPure()) continue;
            return false;
        }
        return true;
    }

    public final BindingEnvironment getBindingEnvironment() {
        return this.m_bindingEnvironment;
    }

    public abstract String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper var1, CodeGenerationTracker var2, String var3, boolean var4);

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        s_logger.error(">> need to implement for " + this.getClass());
    }

    public final boolean supportsCodeGenerationOptimization(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        boolean bl = this.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
        return bl;
    }

    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return false;
    }

    public int getChildInstructionCount() {
        return 0;
    }

    public Instruction getChildInstruction(int n) {
        return null;
    }

    public void setChildInstruction(int n, Instruction instruction) {
    }

    public int getTypeParameterCount() {
        return 0;
    }

    public Type getTypeParameter(int n) {
        return null;
    }

    public void setTypeParameter(int n, Type type) {
    }

    public abstract Instruction cloneWithoutTypeInformation();

    public abstract Instruction cloneShallow();

    public abstract void generateReducedForm(ReductionHelper var1, Instruction[] var2, BindingEnvironment var3);

    public final boolean isBasicExpression() {
        return this instanceof LiteralInstruction || this instanceof IdentifierInstruction;
    }

    public void determineDataDependencies(Binding[] bindingArray, HashMap hashMap, Instruction instruction, int n, BindingEnvironment bindingEnvironment) {
        int n2 = this.getChildInstructionCount();
        for (int i = 0; i < n2; ++i) {
            this.getChildInstruction(i).determineDataDependencies(bindingArray, hashMap, this, i, bindingEnvironment);
        }
    }

    public void determineDataDependencies(Set set) {
        int n = this.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            this.getChildInstruction(i).determineDataDependencies(set);
        }
    }

    public int byteCodeSize() {
        return 1;
    }

    public int accumulateByteCodeSize() {
        int n = this.byteCodeSize();
        int n2 = this.getChildInstructionCount();
        for (int i = 0; i < n2; ++i) {
            n += this.getChildInstruction(i).accumulateByteCodeSize();
        }
        return n;
    }

    public void accumulateFunctionsCalled(Set set) {
        int n = this.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            Instruction instruction = this.getChildInstruction(i);
            instruction.accumulateFunctionsCalled(set);
        }
    }

    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        int n = this.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            this.getChildInstruction(i).accumulateNonLiteralFreeBindings(set, bindingEnvironment);
        }
    }

    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        int n = this.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            this.getChildInstruction(i).accumulateFreeBindings(set, bindingEnvironment);
        }
    }

    public void replaceTypeVariables(Map map) {
        int n = this.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            this.getChildInstruction(i).replaceTypeVariables(map);
        }
    }

    public boolean isStatic(BindingEnvironment bindingEnvironment) {
        return false;
    }

    public String toString() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        this.toString(prettyPrinter, 0);
        return prettyPrinter.toString();
    }

    public String innerToString() {
        return this.getClass().toString();
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen(this.innerToString(), n);
        if (this.getChildInstructionCount() > 0) {
            for (int i = 0; i < this.getChildInstructionCount(); ++i) {
                Instruction instruction = this.getChildInstruction(i);
                if (instruction != null) {
                    instruction.toString(prettyPrinter, n + 1);
                    continue;
                }
                prettyPrinter.printToken("null", n + 1);
            }
        }
        prettyPrinter.printFormClose(n);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        int n = this.getChildInstructionCount();
        Instruction instruction = (Instruction)object;
        if (instruction.getChildInstructionCount() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.getChildInstruction(i).equals(instruction.getChildInstruction(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.getChildInstructionCount();
        return n;
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        throw new UnsupportedOperationException(this.getClass() + " does not implement evaluate.  Instruction:" + this + " function:" + function);
    }

    public void evaluate(IAppendableStream iAppendableStream, Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor) {
        iAppendableStream.append(this.evaluate(environment, function, iDebuggerInterceptor, false));
    }

    public BindingEnvironment evaluateBindingEnvironment(Function function) {
        boolean bl = this.getBindingEnvironment() == null;
        BindingEnvironment bindingEnvironment = bl ? function.getBindingEnvironment() : this.getBindingEnvironment();
        return bindingEnvironment;
    }

    public Type evaluateType(Function function) {
        boolean bl = this.getBindingEnvironment() == null;
        BindingEnvironment bindingEnvironment = this.evaluateBindingEnvironment(function);
        TypeEnvironment typeEnvironment = function.getTypeEnvironment();
        Type type = bl ? this.getType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment) : this.getCachedType().resolveType(typeEnvironment);
        return type;
    }

    public final void debugDump(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen(this.innerToString(), n);
        prettyPrinter.print(" : " + this.m_cachedType);
        if (this.getChildInstructionCount() > 0) {
            for (int i = 0; i < this.getChildInstructionCount(); ++i) {
                Instruction instruction = this.getChildInstruction(i);
                if (instruction != null) {
                    instruction.debugDump(prettyPrinter, n + 1);
                    continue;
                }
                prettyPrinter.printToken("null", n + 1);
            }
        }
        prettyPrinter.printFormClose(n);
    }

    public void clearTypeInformation() {
        this.m_hasBeenTypechecked = false;
        this.m_bindingEnvironment = null;
        int n = this.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            if (this.getChildInstruction(i) == null) {
                throw new RuntimeException();
            }
            this.getChildInstruction(i).clearTypeInformation();
        }
    }

    public Instruction replaceBindings(Map map) {
        int n = this.getChildInstructionCount();
        Instruction instruction = null;
        for (int i = 0; i < n; ++i) {
            Instruction instruction2;
            Instruction instruction3 = this.getChildInstruction(i);
            if (instruction3 == (instruction2 = instruction3.replaceBindings(map))) continue;
            if (instruction == null) {
                instruction = this.cloneShallow();
            }
            instruction.setChildInstruction(i, instruction2);
        }
        return instruction == null ? this : instruction;
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        int n = this.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            this.getChildInstruction(i).typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        }
    }

    public Instruction removeAliases(HashMap hashMap) {
        int n = this.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            Instruction instruction;
            Instruction instruction2 = this.getChildInstruction(i);
            if (instruction2 == (instruction = instruction2.removeAliases(hashMap))) continue;
            this.setChildInstruction(i, instruction);
        }
        return this;
    }

    public Instruction cloneReduced() {
        int n = this.getChildInstructionCount();
        Instruction instruction = this.cloneShallow();
        for (int i = 0; i < n; ++i) {
            Instruction instruction2;
            Instruction instruction3 = this.getChildInstruction(i);
            if (instruction3 == (instruction2 = instruction3.cloneReduced())) continue;
            instruction.setChildInstruction(i, instruction2);
        }
        return instruction;
    }

    public final Instruction assignNewNames(Map map) {
        return this.assignNewNames(map, s_defaultGenerator);
    }

    public final Instruction cloneWithNewNames() {
        return this.assignNewNames(new HashMap());
    }

    public Instruction assignNewNames(Map map, INewNameGenerator iNewNameGenerator) {
        int n = this.getChildInstructionCount();
        Instruction instruction = this.cloneShallow();
        for (int i = 0; i < n; ++i) {
            Instruction instruction2;
            Instruction instruction3 = this.getChildInstruction(i);
            if (instruction3 == (instruction2 = instruction3.assignNewNames(map, iNewNameGenerator))) continue;
            instruction.setChildInstruction(i, instruction2);
        }
        return instruction;
    }

    public final Set accumulateFreeBindingsInOrder(BindingEnvironment bindingEnvironment) {
        OrderedSet orderedSet = new OrderedSet();
        this.accumulateFreeBindings(orderedSet, bindingEnvironment);
        return orderedSet;
    }

    public final IBinding[] accumulateFreeBindingsAsArray(BindingEnvironment bindingEnvironment) {
        Set set = this.accumulateFreeBindingsInOrder(bindingEnvironment);
        IBinding[] iBindingArray = new IBinding[set.size()];
        set.toArray(iBindingArray);
        return iBindingArray;
    }

    public final Instruction generateCanonicalForm(BindingEnvironment bindingEnvironment) {
        Set set = this.accumulateFreeBindingsInOrder(bindingEnvironment);
        if (set == null) {
            throw new XylemError("ERR_SYSTEM", "a-" + this.getClass().getName());
        }
        RepeatingNameGenerator repeatingNameGenerator = new RepeatingNameGenerator("free");
        HashMap<Object, IdentifierInstruction> hashMap = new HashMap<Object, IdentifierInstruction>();
        for (IBinding iBinding : set) {
            if (iBinding == null) {
                throw new XylemError("ERR_SYSTEM", "b-" + this.getClass().getName());
            }
            Object object = iBinding.getName();
            if (object == null) {
                throw new XylemError("ERR_SYSTEM", "c-" + this.getClass().getName());
            }
            hashMap.put(object, new IdentifierInstruction(repeatingNameGenerator.getNewName()));
        }
        return this.assignNewNames(hashMap, new RepeatingNameGenerator());
    }

    public static final Instruction shouldNeverReach(Type type) {
        return new ChooseInstruction(LiteralInstruction.booleanFalseLiteral(), (Instruction)LiteralInstruction.nullLiteral(type), null);
    }

    public static final Instruction shouldNeverReach(Instruction instruction, Function function) {
        if (function.getTypeEnvironment() == null) {
            throw new Error("Expected type-checked function: " + function.getName());
        }
        return Instruction.shouldNeverReach(instruction.getType(function.getTypeEnvironment(), function.getBindingEnvironment()).resolveType(function.getTypeEnvironment()));
    }

    public final int getChildInstructionIndex(Instruction instruction) {
        int n = this.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            if (this.getChildInstruction(i) != instruction) continue;
            return i;
        }
        return -1;
    }

    public Type setCachedType(Type type) {
        this.m_cachedType = type;
        return this.m_cachedType;
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        int n = this.getChildInstructionCount();
        writeObjectFileHelper.writeInt(n);
        for (int i = 0; i < n; ++i) {
            writeObjectFileHelper.writeInstruction(this.getChildInstruction(i));
        }
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        int n = this.getChildInstructionCount();
        if (readObjectFileHelper.readInt() != n) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < n; ++i) {
            this.setChildInstruction(i, readObjectFileHelper.readInstruction(bindingEnvironment));
        }
    }

    public boolean isDescendentInstruction(Instruction instruction) {
        Instruction instruction2 = this;
        while (instruction2 != instruction) {
            int n = instruction2.getChildInstructionCount();
            if (n == 0) {
                return false;
            }
            for (int i = 0; i < n - 1; ++i) {
                Instruction instruction3 = instruction2.getChildInstruction(i);
                if (instruction3 == instruction) {
                    return true;
                }
                if (!instruction3.isDescendentInstruction(instruction)) continue;
                return true;
            }
            instruction2 = instruction2.getChildInstruction(n - 1);
        }
        return true;
    }

    public void standardizeTypes(Set set, TypeEnvironment typeEnvironment) {
        Instruction instruction = this;
        while (true) {
            int n;
            int n2 = instruction.getTypeParameterCount();
            for (n = 0; n < n2; ++n) {
                Type type = instruction.getTypeParameter(n).resolveTypeAsMuchAsPossible(typeEnvironment, set);
                instruction.setTypeParameter(n, type);
            }
            if (instruction.m_cachedType != null) {
                Type type;
                instruction.m_cachedType = type = instruction.m_cachedType.resolveTypeAsMuchAsPossible(typeEnvironment, set);
            }
            if ((n = instruction.getChildInstructionCount()) == 0) {
                return;
            }
            for (int i = 0; i < n - 1; ++i) {
                Instruction instruction2 = instruction.getChildInstruction(i);
                instruction2.standardizeTypes(set, typeEnvironment);
            }
            instruction = instruction.getChildInstruction(n - 1);
        }
    }

    public void instantiateReducedPolymorphicFunctions(Set set, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, Set set2, Set set3) {
        int n = this.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            Instruction instruction = this.getChildInstruction(i);
            instruction.instantiateReducedPolymorphicFunctions(set, typeEnvironment, bindingEnvironment, set2, set3);
        }
    }

    public final boolean doesDescendentCountExceedThreshold(int n) {
        return this.doesDescendentCountExceedThresholdHelper(n) < 0;
    }

    protected int doesDescendentCountExceedThresholdHelper(int n) {
        int n2 = this.getChildInstructionCount();
        if ((n -= n2) < 0) {
            return n;
        }
        for (int i = 0; i < n2 && (n = this.getChildInstruction(i).doesDescendentCountExceedThresholdHelper(n)) >= 0; ++i) {
        }
        return n;
    }

    public final void expandTypeAliases(Module module) {
        if (this.typeAliasesExpanded) {
            throw new XylemError("ERR_SYSTEM", "Internal compiler error: type aliases already expanded.");
        }
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        arrayList.add(this);
        while (!arrayList.isEmpty()) {
            int n;
            int n2 = arrayList.size() - 1;
            Instruction instruction = (Instruction)arrayList.get(n2);
            int n3 = instruction.getChildInstructionCount();
            arrayList.ensureCapacity(n2 + n3);
            if (n3 == 0 || instruction.typeAliasesExpanded) {
                arrayList.remove(n2);
                n = instruction.getTypeParameterCount();
                for (int i = 0; i < n; ++i) {
                    Type type = instruction.getTypeParameter(i);
                    if (type == null) continue;
                    instruction.setTypeParameter(i, type.expandTypeAliases(module));
                }
            } else {
                for (n = n3 - 1; n >= 0; --n) {
                    Instruction instruction2 = instruction.getChildInstruction(n);
                    if (instruction2.typeAliasesExpanded) continue;
                    arrayList.add(instruction2);
                }
            }
            instruction.typeAliasesExpanded = true;
        }
    }
}

