/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.runtime.output;

import com.ibm.xtq.scontext.MergedCharacterMapsManager;
import com.ibm.xtq.xslt.runtime.CharacterMapsImpl;
import com.ibm.xtq.xslt.runtime.Converter;
import com.ibm.xtq.xslt.runtime.ConverterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.Serializer;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;

public class TransletOutputHandlerFactory {
    public static final int STREAM = 0;
    public static final int SAX = 1;
    public static final int DOM = 2;
    private String _method = null;
    private int _outputType = 0;
    private OutputStream _ostream = System.out;
    private Writer _writer = null;
    private Node _node = null;
    private Node _nextSibling = null;
    private ContentHandler _handler = null;
    private LexicalHandler _lexHandler = null;
    private Converter _converter = null;
    private MergedCharacterMapsManager _charMapMgr = null;

    public static TransletOutputHandlerFactory newInstance() {
        return new TransletOutputHandlerFactory();
    }

    public void setOutputType(int n) {
        this._outputType = n;
    }

    public void setOutputMethod(String string) {
        this._method = string;
    }

    public void setOutputStream(OutputStream outputStream) {
        this._ostream = outputStream;
    }

    public void setWriter(Writer writer) {
        this._writer = writer;
    }

    public void setHandler(ContentHandler contentHandler) {
        this._handler = contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this._lexHandler = lexicalHandler;
    }

    public void setNode(Node node) {
        this._node = node;
    }

    public void setNextSibling(Node node) {
        this._nextSibling = node;
    }

    public void setCharMapManager(MergedCharacterMapsManager mergedCharacterMapsManager) {
        this._charMapMgr = mergedCharacterMapsManager;
    }

    public Node getNode() {
        return this._converter != null ? this._converter.getOutputDOM() : null;
    }

    public SerializationHandler getSerializationHandler(SerializationHandler serializationHandler) throws IOException, ParserConfigurationException {
        Serializer serializer = null;
        String string = this._outputType == 2 || this._outputType == 1 ? "xml" : this._method;
        if (string == null) {
            string = "";
        }
        Properties properties = OutputPropertiesFactory.getDefaultMethodProperties(string);
        Converter converter = ConverterFactory.getConverter();
        converter.setOutputFormat(properties);
        switch (this._outputType) {
            case 0: {
                if (this._writer != null) {
                    converter.setOutputWriter(this._writer);
                } else {
                    converter.setOutputStream(this._ostream);
                }
                serializer = converter.getInputSerializationHandler(serializationHandler);
                break;
            }
            case 2: {
                this._converter = converter;
                converter.setOutputDOM(this._node);
                if (this._nextSibling != null) {
                    converter.setNextSibling(this._nextSibling);
                }
                if (this._handler instanceof LexicalHandler) {
                    converter.setOutputLexicalHandler((LexicalHandler)((Object)this._handler));
                }
                serializer = converter.getInputSerializationHandler(serializationHandler);
                break;
            }
            case 1: {
                converter.setOutputContentHandler(this._handler);
                converter.setOutputLexicalHandler(this._lexHandler);
                serializer = converter.getInputSerializationHandler(serializationHandler);
            }
        }
        if (this._charMapMgr != null) {
            CharacterMapsImpl characterMapsImpl = new CharacterMapsImpl(this._charMapMgr);
            serializer.setCharacterMaps(characterMapsImpl);
        } else {
            serializer.setCharacterMaps(null);
        }
        return serializer;
    }
}

