/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeError;
import com.ibm.xtq.xml.xdm.res.XMLMessages;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XDouble
extends XItemBase {
    private double m_value;

    public XDouble(double d) {
        this.m_value = d;
        this.m_type = Type.DOUBLE;
    }

    public XDouble(double d, ItemType itemType) {
        this.m_value = d;
        this.m_type = itemType;
    }

    @Override
    public int getPrimitiveId() {
        return 3;
    }

    public static XDouble valueOf(double d) {
        return new XDouble(d);
    }

    public static XDouble valueOf(String string) {
        return new XDouble(CastLibrary.toDouble(string));
    }

    @Override
    public double getCurrentItemAsDouble() throws TypeError {
        return this.m_value;
    }

    @Override
    public boolean toBoolean() {
        return CastLibrary.toBoolean(this.m_value);
    }

    @Override
    public BigDecimal toDecimal() {
        return CastLibrary.toDecimal(this.m_value);
    }

    @Override
    public double toDouble() {
        return this.m_value;
    }

    @Override
    public float toFloat() {
        return CastLibrary.toFloat(this.m_value);
    }

    @Override
    public BigInteger toInteger() {
        return CastLibrary.toInteger(this.m_value);
    }

    @Override
    public String toString() {
        return CastLibrary.toString(this.m_value);
    }

    @Override
    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    @Override
    public XItem add(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new XDouble(this.m_value + xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    @Override
    public XItem subtract(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new XDouble(this.m_value - xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    @Override
    public XItem multiply(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new XDouble(this.m_value * xItem.toDouble());
            }
            case 8: {
                return xItem.toDayTimeDuration().multiply(this.toDouble());
            }
            case 7: {
                return xItem.toYearMonthDuration().multiply(this.toDouble());
            }
        }
        throw new TypeError();
    }

    @Override
    public XItem divide(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new XDouble(this.m_value / xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public double idiv(double d) throws TypeError {
        throw new TypeError();
    }

    @Override
    public final XItem mod(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new XDouble(this.mod(xItem.toDouble()));
            }
        }
        throw new TypeError(XMLMessages.createXMLMessage("TYPE_ERR_TYPE_UNMATCH", new Object[]{this.getType(), xItem.getType()}));
    }

    public final double mod(double d) throws TypeError {
        return this.m_value % d;
    }

    @Override
    public XItem negate() throws TypeError {
        return new XDouble(-this.m_value);
    }

    @Override
    public boolean equals(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.equals(xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public final boolean equals(double d) throws TypeError {
        double d2 = XDouble.compare(this.m_value, d);
        if (Double.isNaN(d2)) {
            return false;
        }
        return d2 == 0.0;
    }

    public final boolean notEquals(double d) throws TypeError {
        return !this.equals(d);
    }

    @Override
    public int compareTo(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.compareTo(xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public final int compareTo(double d) throws TypeError {
        return (int)XDouble.compare(this.m_value, d);
    }

    public final boolean greaterThan(double d) throws TypeError {
        double d2 = XDouble.compare(this.m_value, d);
        if (Double.isNaN(d2)) {
            return false;
        }
        return d2 > 0.0;
    }

    public final boolean greaterOrEquals(double d) throws TypeError {
        double d2 = XDouble.compare(this.m_value, d);
        if (Double.isNaN(d2)) {
            return false;
        }
        return d2 >= 0.0;
    }

    public final boolean lessThan(double d) throws TypeError {
        double d2 = XDouble.compare(this.m_value, d);
        if (Double.isNaN(d2)) {
            return false;
        }
        return d2 < 0.0;
    }

    public final boolean lessOrEquals(double d) throws TypeError {
        double d2 = XDouble.compare(this.m_value, d);
        if (Double.isNaN(d2)) {
            return false;
        }
        return d2 <= 0.0;
    }

    public static final double compare(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d == -0.0 && d2 == 0.0) {
            return 0.0;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return d2 == Double.POSITIVE_INFINITY ? 0.0 : 1.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return d2 == Double.NEGATIVE_INFINITY ? 0.0 : -1.0;
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return d == Double.POSITIVE_INFINITY ? 0.0 : -1.0;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return d == Double.NEGATIVE_INFINITY ? 0.0 : 1.0;
        }
        if (d == d2) {
            return 0.0;
        }
        if (d > d2) {
            return 1.0;
        }
        return -1.0;
    }
}

