/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.Field;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ValidatePipelineDefinitionRequestMarshaller
implements Marshaller<Request<ValidatePipelineDefinitionRequest>, ValidatePipelineDefinitionRequest> {
    public Request<ValidatePipelineDefinitionRequest> marshall(ValidatePipelineDefinitionRequest validatePipelineDefinitionRequest) {
        if (validatePipelineDefinitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)validatePipelineDefinitionRequest, "DataPipeline");
        String target = "DataPipeline.ValidatePipelineDefinition";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag pipelineObjectsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (validatePipelineDefinitionRequest.getPipelineId() != null) {
                jsonWriter.key("pipelineId").value((Object)validatePipelineDefinitionRequest.getPipelineId());
            }
            if (!((pipelineObjectsList = (ListWithAutoConstructFlag)validatePipelineDefinitionRequest.getPipelineObjects()) == null || pipelineObjectsList.isAutoConstruct() && pipelineObjectsList.isEmpty())) {
                jsonWriter.key("pipelineObjects");
                jsonWriter.array();
                for (PipelineObject pipelineObjectsListValue : pipelineObjectsList) {
                    ListWithAutoConstructFlag fieldsList;
                    if (pipelineObjectsListValue == null) continue;
                    jsonWriter.object();
                    if (pipelineObjectsListValue.getId() != null) {
                        jsonWriter.key("id").value((Object)pipelineObjectsListValue.getId());
                    }
                    if (pipelineObjectsListValue.getName() != null) {
                        jsonWriter.key("name").value((Object)pipelineObjectsListValue.getName());
                    }
                    if (!((fieldsList = (ListWithAutoConstructFlag)pipelineObjectsListValue.getFields()) == null || fieldsList.isAutoConstruct() && fieldsList.isEmpty())) {
                        jsonWriter.key("fields");
                        jsonWriter.array();
                        for (Field fieldsListValue : fieldsList) {
                            if (fieldsListValue == null) continue;
                            jsonWriter.object();
                            if (fieldsListValue.getKey() != null) {
                                jsonWriter.key("key").value((Object)fieldsListValue.getKey());
                            }
                            if (fieldsListValue.getStringValue() != null) {
                                jsonWriter.key("stringValue").value((Object)fieldsListValue.getStringValue());
                            }
                            if (fieldsListValue.getRefValue() != null) {
                                jsonWriter.key("refValue").value((Object)fieldsListValue.getRefValue());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

