/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.tomcat.util.res.StringManager;

public class CometEventImpl
implements CometEvent {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected Request request = null;
    protected Response response = null;
    protected CometEvent.EventType eventType = CometEvent.EventType.BEGIN;
    protected CometEvent.EventSubType eventSubType = null;

    public CometEventImpl(Request request, Response response) {
        this.request = request;
        this.response = response;
    }

    public void clear() {
        this.request = null;
        this.response = null;
    }

    public void setEventType(CometEvent.EventType eventType) {
        this.eventType = eventType;
    }

    public void setEventSubType(CometEvent.EventSubType eventSubType) {
        this.eventSubType = eventSubType;
    }

    @Override
    public void close() throws IOException {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("cometEvent.nullRequest"));
        }
        boolean iscomet = this.request.isComet();
        this.request.setComet(false);
        this.request.finishRequest();
        this.response.finishResponse();
        if (iscomet) {
            this.request.cometClose();
        }
    }

    @Override
    public CometEvent.EventSubType getEventSubType() {
        return this.eventSubType;
    }

    @Override
    public CometEvent.EventType getEventType() {
        return this.eventType;
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.request.getRequest();
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return this.response.getResponse();
    }

    @Override
    public void setTimeout(int timeout) throws IOException, ServletException, UnsupportedOperationException {
        if (this.request.getAttribute("org.apache.tomcat.comet.timeout.support") == Boolean.TRUE) {
            this.request.setAttribute("org.apache.tomcat.comet.timeout", timeout);
            if (this.request.isComet()) {
                this.request.setCometTimeout(timeout);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append("[EventType:");
        buf.append((Object)this.eventType);
        buf.append(", EventSubType:");
        buf.append((Object)this.eventSubType);
        buf.append("]");
        return buf.toString();
    }
}

