/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.authorization;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.authorization.AuthorizationCache;
import org.wso2.carbon.user.core.authorization.AuthorizationCacheException;
import org.wso2.carbon.user.core.authorization.PermissionTree;
import org.wso2.carbon.user.core.authorization.PermissionTreeUtil;
import org.wso2.carbon.user.core.authorization.SearchResult;
import org.wso2.carbon.user.core.authorization.TreeNode;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.internal.UMListenerServiceComponent;
import org.wso2.carbon.user.core.listener.AuthorizationManagerListener;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class JDBCAuthorizationManager
implements AuthorizationManager {
    private DataSource dataSource = null;
    private PermissionTree permissionTree = null;
    private AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
    private UserRealm userRealm = null;
    private RealmConfiguration realmConfig = null;
    private boolean caseInSensitiveAuthorizationRules;
    private String cacheIdentifier;
    private int tenantId;
    private static Log log = LogFactory.getLog(JDBCAuthorizationManager.class);
    private static boolean debug = log.isDebugEnabled();

    public JDBCAuthorizationManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        String userCoreCacheIdentifier;
        if (!"true".equals(realmConfig.getAuthorizationManagerProperty("AuthorizationCacheEnabled"))) {
            this.authorizationCache.disableCache();
        }
        if (!"true".equals(realmConfig.getAuthorizationManagerProperty("CaseSensitiveAuthorizationRules"))) {
            this.caseInSensitiveAuthorizationRules = true;
        }
        this.cacheIdentifier = (userCoreCacheIdentifier = realmConfig.getUserStoreProperty("UserCoreCacheIdentifier")) != null && userCoreCacheIdentifier.trim().length() > 0 ? userCoreCacheIdentifier : "defaultCacheDomain";
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
            properties.put("um.datasource", this.dataSource);
        }
        this.permissionTree = new PermissionTree(this.cacheIdentifier, tenantId, this.dataSource);
        this.realmConfig = realmConfig;
        this.userRealm = realm;
        this.tenantId = tenantId;
        if (log.isDebugEnabled()) {
            log.debug((Object)("The jdbcDataSource being used by JDBCAuthorizationManager :: " + this.dataSource.hashCode()));
        }
        this.populatePermissionTreeFromDB();
        this.addInitialData();
    }

    @Override
    public boolean isRoleAuthorized(String roleName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.isRoleAuthorized(roleName, resourceId, action, this)) continue;
            return false;
        }
        roleName = this.modify(roleName);
        resourceId = this.modify(resourceId);
        action = this.modify(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getRolePermission(roleName, PermissionTreeUtil.actionToPermission(action), null, null, PermissionTreeUtil.toComponenets(resourceId));
        if (log.isDebugEnabled() && !sr.getLastNodeAllowedAccess().booleanValue()) {
            log.debug((Object)(roleName + " role is not Authorized to perform " + action + " on " + resourceId));
        }
        return sr.getLastNodeAllowedAccess();
    }

    @Override
    public boolean isUserAuthorized(String userName, String resourceId, String action) throws UserStoreException {
        if ("wso2.system.user".equals(userName)) {
            return true;
        }
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.isUserAuthorized(userName, resourceId, action, this)) continue;
            return false;
        }
        String unModifiedUser = userName;
        userName = this.modify(userName);
        resourceId = this.modify(resourceId);
        action = this.modify(action);
        try {
            Boolean userAllowed = this.authorizationCache.isUserAuthorized(this.cacheIdentifier, this.tenantId, userName, resourceId, action);
            if (log.isDebugEnabled() && userAllowed != null && !userAllowed.booleanValue()) {
                log.debug((Object)("Authorization cache hit. " + userName + " user is not Authorized to perform " + action + " on " + resourceId));
            }
            if (userAllowed != null) {
                return userAllowed;
            }
        }
        catch (AuthorizationCacheException e) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authorization cache miss for username : " + userName + " resource " + resourceId + " action : " + action));
        }
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getUserPermission(userName, PermissionTreeUtil.actionToPermission(action), null, null, PermissionTreeUtil.toComponenets(resourceId));
        if (sr.getLastNodeAllowedAccess().booleanValue()) {
            this.authorizationCache.addToCache(this.cacheIdentifier, this.tenantId, userName, resourceId, action, true);
            return true;
        }
        boolean userAllowed = false;
        String[] allowedRoles = this.modify(this.getAllowedRolesForResource(resourceId, action));
        if (allowedRoles != null && allowedRoles.length > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Roles which have permission for resource : " + resourceId + " action : " + action));
                for (String allowedRole : allowedRoles) {
                    log.debug((Object)("Role :  " + allowedRole));
                }
            }
            AbstractUserStoreManager manager = (AbstractUserStoreManager)this.userRealm.getUserStoreManager();
            for (String role : allowedRoles) {
                if (manager.isUserInRole(unModifiedUser, role)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(unModifiedUser + " user is in role :  " + role));
                    }
                    userAllowed = true;
                    break;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(unModifiedUser + " user is not in role :  " + role));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No roles have permission for resource : " + resourceId + " action : " + action));
        }
        this.authorizationCache.addToCache(this.cacheIdentifier, this.tenantId, userName, resourceId, action, userAllowed);
        if (log.isDebugEnabled() && !userAllowed) {
            log.debug((Object)(userName + " user is not Authorized to perform " + action + " on " + resourceId));
        }
        return userAllowed;
    }

    @Override
    public String[] getAllowedRolesForResource(String resourceId, String action) throws UserStoreException {
        resourceId = this.modify(resourceId);
        action = this.modify(action);
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getAllowedRolesForResource(null, null, permission, PermissionTreeUtil.toComponenets(resourceId));
        if (debug) {
            String[] roles;
            log.debug((Object)("Allowed roles for the ResourceID: " + resourceId + " Action: " + action));
            for (String role : roles = sr.getAllowedEntities().toArray(new String[sr.getAllowedEntities().size()])) {
                log.debug((Object)("role: " + role));
            }
        }
        return sr.getAllowedEntities().toArray(new String[sr.getAllowedEntities().size()]);
    }

    @Override
    public String[] getExplicitlyAllowedUsersForResource(String resourceId, String action) throws UserStoreException {
        resourceId = this.modify(resourceId);
        action = this.modify(action);
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getAllowedUsersForResource(null, null, permission, PermissionTreeUtil.toComponenets(resourceId));
        if (debug) {
            String[] roles;
            log.debug((Object)("Explicityly allowed roles for the ResourceID: " + resourceId + " Action: " + action));
            for (String role : roles = sr.getAllowedEntities().toArray(new String[sr.getAllowedEntities().size()])) {
                log.debug((Object)("role: " + role));
            }
        }
        return sr.getAllowedEntities().toArray(new String[sr.getAllowedEntities().size()]);
    }

    @Override
    public String[] getDeniedRolesForResource(String resourceId, String action) throws UserStoreException {
        resourceId = this.modify(resourceId);
        action = this.modify(action);
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getDeniedRolesForResource(null, null, permission, PermissionTreeUtil.toComponenets(resourceId));
        return sr.getDeniedEntities().toArray(new String[sr.getAllowedEntities().size()]);
    }

    @Override
    public String[] getExplicitlyDeniedUsersForResource(String resourceId, String action) throws UserStoreException {
        resourceId = this.modify(resourceId);
        action = this.modify(action);
        TreeNode.Permission permission = PermissionTreeUtil.actionToPermission(action);
        this.permissionTree.updatePermissionTree();
        SearchResult sr = this.permissionTree.getDeniedUsersForResource(null, null, permission, PermissionTreeUtil.toComponenets(resourceId));
        return sr.getDeniedEntities().toArray(new String[sr.getAllowedEntities().size()]);
    }

    @Override
    public String[] getAllowedUIResourcesForUser(String userName, String permissionRootPath) throws UserStoreException {
        permissionRootPath = this.modify(permissionRootPath);
        ArrayList<String> lstPermissions = new ArrayList<String>();
        List<String> resourceIds = this.getUIPermissionId();
        if (resourceIds != null) {
            for (String resourceId : resourceIds) {
                if (!this.isUserAuthorized(userName, resourceId, "ui.execute")) continue;
                lstPermissions.add(resourceId);
            }
        }
        String[] permissions = lstPermissions.toArray(new String[lstPermissions.size()]);
        String[] optimizedList = UserCoreUtil.optimizePermissions(permissions);
        if (debug) {
            log.debug((Object)("Allowed UI Resources for User: " + userName + " in permissionRootPath: " + permissionRootPath));
            for (String resource : optimizedList) {
                log.debug((Object)("Resource: " + resource));
            }
        }
        return optimizedList;
    }

    @Override
    public void authorizeRole(String roleName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.authorizeRole(roleName, resourceId, action, this)) continue;
            return;
        }
        if (resourceId == null || action == null) {
            log.error((Object)"Invalid data provided at authorization code");
            throw new UserStoreException("Invalid data provided");
        }
        roleName = this.modify(roleName);
        resourceId = this.modify(resourceId);
        action = this.modify(action);
        this.addAuthorizationForRole(roleName, resourceId, action, (short)1, true);
    }

    @Override
    public void denyRole(String roleName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.denyRole(roleName, resourceId, action, this)) continue;
            return;
        }
        if (resourceId == null || action == null) {
            log.error((Object)"Invalid data provided at authorization code");
            throw new UserStoreException("Invalid data provided");
        }
        roleName = this.modify(roleName);
        resourceId = this.modify(resourceId);
        action = this.modify(action);
        this.addAuthorizationForRole(roleName, resourceId, action, (short)0, true);
    }

    @Override
    public void authorizeUser(String userName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.authorizeUser(userName, resourceId, action, this)) continue;
            return;
        }
        if (resourceId == null || action == null) {
            log.error((Object)"Invalid data provided at authorization code");
            throw new UserStoreException("Invalid data provided");
        }
        userName = this.modify(userName);
        resourceId = this.modify(resourceId);
        action = this.modify(action);
        this.addAuthorizationForUser(userName, resourceId, action, (short)1, true);
    }

    @Override
    public void denyUser(String userName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.denyUser(userName, resourceId, action, this)) continue;
            return;
        }
        if (resourceId == null || action == null) {
            log.error((Object)"Invalid data provided at authorization code");
            throw new UserStoreException("Invalid data provided");
        }
        userName = this.modify(userName);
        resourceId = this.modify(resourceId);
        action = this.modify(action);
        this.addAuthorizationForUser(userName, resourceId, action, (short)0, true);
    }

    @Override
    public void clearResourceAuthorizations(String resourceId) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearResourceAuthorizations(resourceId, this)) continue;
            return;
        }
        resourceId = this.modify(resourceId);
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_PERMISSION_ID IN (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID=?) AND UM_TENANT_ID=?", resourceId, this.tenantId);
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_USER_PERMISSION WHERE UM_PERMISSION_ID IN (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID=?) AND UM_TENANT_ID=?", resourceId, this.tenantId);
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_TENANT_ID=?", resourceId, this.tenantId);
            this.permissionTree.clearResourceAuthorizations(resourceId);
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
            throw new UserStoreException("Error! " + e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void clearRoleAuthorization(String roleName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearRoleAuthorization(roleName, resourceId, action, this)) continue;
            return;
        }
        roleName = this.modify(roleName);
        resourceId = this.modify(resourceId);
        action = this.modify(action);
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String domain = UserCoreUtil.extractDomainFromName(roleName);
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)", UserCoreUtil.removeDomainFromName(roleName), resourceId, action, this.tenantId, this.tenantId, this.tenantId, domain);
            this.permissionTree.clearRoleAuthorization(roleName, resourceId, action);
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
            throw new UserStoreException("Error! " + e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    @Override
    public void clearUserAuthorization(String userName, String resourceId, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearUserAuthorization(userName, resourceId, action, this)) continue;
            return;
        }
        userName = this.modify(userName);
        resourceId = this.modify(resourceId);
        action = this.modify(action);
        this.authorizationCache.clearCacheEntry(this.cacheIdentifier, this.tenantId, userName, resourceId, action);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            int permissionId = this.getPermissionId(dbConnection, resourceId, action);
            if (permissionId == -1) {
                this.addPermissionId(dbConnection, resourceId, action);
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_USER_PERMISSION WHERE UM_USER_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", userName, resourceId, action, this.tenantId, this.tenantId);
            this.permissionTree.clearUserAuthorization(userName, resourceId, action);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void clearRoleActionOnAllResources(String roleName, String action) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearRoleActionOnAllResources(roleName, action, this)) continue;
            return;
        }
        roleName = this.modify(roleName);
        action = this.modify(action);
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            this.permissionTree.clearRoleAuthorization(roleName, action);
            String domain = UserCoreUtil.extractDomainFromName(roleName);
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_PERMISSION_ID IN (SELECT UM_ID FROM UM_PERMISSION WHERE UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)", UserCoreUtil.removeDomainFromName(roleName), action, this.tenantId, this.tenantId, this.tenantId, domain);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void clearRoleAuthorization(String roleName) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearRoleAuthorization(roleName, this)) continue;
            return;
        }
        roleName = this.modify(roleName);
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            this.permissionTree.clearRoleAuthorization(roleName);
            String domain = UserCoreUtil.extractDomainFromName(roleName);
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)", UserCoreUtil.removeDomainFromName(roleName), this.tenantId, this.tenantId, domain);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void clearUserAuthorization(String userName) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.clearUserAuthorization(userName, this)) continue;
            return;
        }
        userName = this.modify(userName);
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            this.permissionTree.clearUserAuthorization(userName);
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_USER_PERMISSION WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", userName, this.tenantId);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void resetPermissionOnUpdateRole(String roleName, String newRoleName) throws UserStoreException {
        for (AuthorizationManagerListener listener : UMListenerServiceComponent.getAuthorizationManagerListeners()) {
            if (listener.resetPermissionOnUpdateRole(roleName, newRoleName, this)) continue;
            return;
        }
        roleName = this.modify(roleName);
        newRoleName = this.modify(newRoleName);
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        String sqlStmt = "UPDATE UM_ROLE_PERMISSION set UM_ROLE_NAME=? WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)";
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for update role name is null");
        }
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            this.permissionTree.updateRoleNameInCache(roleName, newRoleName);
            String domain = UserCoreUtil.extractDomainFromName(newRoleName);
            newRoleName = UserCoreUtil.removeDomainFromName(newRoleName);
            roleName = UserCoreUtil.removeDomainFromName(roleName);
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            DatabaseUtil.updateDatabase(dbConnection, sqlStmt, newRoleName, roleName, this.tenantId, this.tenantId, domain);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    public void addAuthorization(String subject, String resourceId, String action, boolean authorized, boolean isRole) throws UserStoreException {
        short allow = 0;
        if (authorized) {
            allow = 1;
        }
        if (isRole) {
            this.addAuthorizationForRole(subject, resourceId, action, allow, false);
        } else {
            this.addAuthorizationForUser(subject, resourceId, action, allow, false);
        }
    }

    private void addAuthorizationForRole(String roleName, String resourceId, String action, short allow, boolean updateCache) throws UserStoreException {
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            boolean isSystemRole;
            String domain;
            dbConnection = this.getDBConnection();
            int permissionId = this.getPermissionId(dbConnection, resourceId, action);
            if (permissionId == -1) {
                this.addPermissionId(dbConnection, resourceId, action);
                permissionId = this.getPermissionId(dbConnection, resourceId, action);
            }
            if ((domain = UserCoreUtil.extractDomainFromName(roleName)) != null) {
                domain = domain.toUpperCase();
            }
            if (isSystemRole = UserCoreUtil.isSystemRole(roleName, this.tenantId, this.dataSource)) {
                domain = "SYSTEM";
            } else if (domain == null) {
                domain = "PRIMARY";
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_ROLE_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=? AND UM_DOMAIN_ID=(SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?)", UserCoreUtil.removeDomainFromName(roleName), resourceId, action, this.tenantId, this.tenantId, this.tenantId, domain);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding permission Id: " + permissionId + " to the role: " + UserCoreUtil.removeDomainFromName(roleName) + " of tenant: " + this.tenantId + " of domain: " + domain + " to resource: " + resourceId));
            }
            DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_ROLE_PERMISSION (UM_PERMISSION_ID, UM_ROLE_NAME, UM_IS_ALLOWED, UM_TENANT_ID, UM_DOMAIN_ID) VALUES (?, ?, ?, ?, (SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_TENANT_ID=? AND UM_DOMAIN_NAME=?))", permissionId, UserCoreUtil.removeDomainFromName(roleName), allow, this.tenantId, this.tenantId, domain);
            if (updateCache) {
                if (allow == 1) {
                    this.permissionTree.authorizeRoleInTree(roleName, resourceId, action, true);
                } else {
                    this.permissionTree.denyRoleInTree(roleName, resourceId, action, true);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    private void addAuthorizationForUser(String userName, String resourceId, String action, short allow, boolean updateCache) throws UserStoreException {
        this.authorizationCache.clearCacheByTenant(this.tenantId);
        Connection dbConnection = null;
        Object prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            int permissionId = this.getPermissionId(dbConnection, resourceId, action);
            if (permissionId == -1) {
                this.addPermissionId(dbConnection, resourceId, action);
                permissionId = this.getPermissionId(dbConnection, resourceId, action);
            }
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_USER_PERMISSION WHERE UM_USER_NAME=? AND UM_PERMISSION_ID = (SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID = ? AND UM_ACTION = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", userName, resourceId, action, this.tenantId, this.tenantId);
            DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_USER_PERMISSION (UM_PERMISSION_ID, UM_USER_NAME, UM_IS_ALLOWED, UM_TENANT_ID) VALUES (?, ?, ?, ?)", permissionId, userName, allow, this.tenantId);
            if (updateCache) {
                if (allow == 1) {
                    this.permissionTree.authorizeUserInTree(userName, resourceId, action, true);
                } else {
                    this.permissionTree.denyUserInTree(userName, resourceId, action, true);
                    this.authorizationCache.clearCacheEntry(this.cacheIdentifier, this.tenantId, userName, resourceId, action);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    private List<String> getUIPermissionId() throws UserStoreException {
        ArrayList<String> arrayList;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<String> resourceIds = new ArrayList<String>();
        try {
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement("SELECT UM_RESOURCE_ID FROM UM_PERMISSION WHERE UM_ACTION=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, "ui.execute");
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    resourceIds.add(rs.getString(1));
                }
            }
            arrayList = resourceIds;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return arrayList;
    }

    private int getPermissionId(Connection dbConnection, String resourceId, String action) throws UserStoreException {
        int n;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int value = -1;
        try {
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_PERMISSION WHERE UM_RESOURCE_ID=? AND UM_ACTION=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, resourceId);
            prepStmt.setString(2, action);
            prepStmt.setInt(3, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                value = rs.getInt(1);
            }
            n = value;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return n;
    }

    private void addPermissionId(Connection dbConnection, String resourceId, String action) throws UserStoreException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = dbConnection.prepareStatement("INSERT INTO UM_PERMISSION (UM_RESOURCE_ID, UM_ACTION, UM_TENANT_ID) VALUES (?, ?, ?)");
            prepStmt.setString(1, resourceId);
            prepStmt.setString(2, action);
            prepStmt.setInt(3, this.tenantId);
            int count = prepStmt.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executed querry is INSERT INTO UM_PERMISSION (UM_RESOURCE_ID, UM_ACTION, UM_TENANT_ID) VALUES (?, ?, ?) and number of updated rows :: " + count));
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    private Connection getDBConnection() throws SQLException {
        Connection dbConnection = this.dataSource.getConnection();
        dbConnection.setAutoCommit(false);
        return dbConnection;
    }

    public void populatePermissionTreeFromDB() throws UserStoreException {
        this.permissionTree.updatePermissionTreeFromDB();
    }

    public void clearPermissionTree() {
        this.permissionTree.clear();
        this.authorizationCache.clearCache();
    }

    @Override
    public int getTenantId() throws UserStoreException {
        return this.tenantId;
    }

    private String modify(String name) {
        if (this.caseInSensitiveAuthorizationRules && name != null) {
            return name.toLowerCase();
        }
        return name;
    }

    private String[] modify(String[] names) {
        if (this.caseInSensitiveAuthorizationRules && names != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String name : names) {
                list.add(name.toLowerCase());
            }
            return list.toArray(new String[list.size()]);
        }
        return names;
    }

    private void addInitialData() throws UserStoreException {
        String mgtPermissions = this.realmConfig.getAuthorizationManagerProperty("EveryoneRoleManagementPermissions");
        if (mgtPermissions != null) {
            String[] resourceIds;
            String everyoneRole = this.realmConfig.getEveryOneRoleName();
            for (String resourceId : resourceIds = mgtPermissions.split(",")) {
                if (this.isRoleAuthorized(everyoneRole, resourceId, "ui.execute")) continue;
                this.authorizeRole(everyoneRole, resourceId, "ui.execute");
            }
        }
        if ((mgtPermissions = this.realmConfig.getAuthorizationManagerProperty("AdminRoleManagementPermissions")) != null) {
            String[] resourceIds = mgtPermissions.split(",");
            String adminRole = this.realmConfig.getAdminRoleName();
            for (String resourceId : resourceIds) {
                if (this.isRoleAuthorized(adminRole, resourceId, "ui.execute")) continue;
                if (this.userRealm.getUserStoreManager().isReadOnly()) {
                    String readLDAPGroups = (String)this.realmConfig.getUserStoreProperties().get("ReadLDAPGroups");
                    if (readLDAPGroups != null) {
                        if (!Boolean.parseBoolean(readLDAPGroups)) {
                            this.authorizeRole("Internal/" + UserCoreUtil.removeDomainFromName(adminRole), resourceId, "ui.execute");
                            return;
                        }
                    } else {
                        this.authorizeRole("Internal/" + UserCoreUtil.removeDomainFromName(adminRole), resourceId, "ui.execute");
                        return;
                    }
                }
                adminRole = UserCoreUtil.addDomainToName(adminRole, this.realmConfig.getUserStoreProperty("DomainName"));
                this.authorizeRole(adminRole, resourceId, "ui.execute");
            }
        }
    }

    @Override
    public String[] normalizeRoles(String[] roles) {
        if (roles != null && roles.length > 0) {
            int index = 0;
            ArrayList<String> normalizedRoles = new ArrayList<String>();
            for (String role : roles) {
                index = role.indexOf("@".toLowerCase());
                if (index >= 0) {
                    normalizedRoles.add(role.substring(0, index));
                    continue;
                }
                normalizedRoles.add(role);
            }
            return normalizedRoles.toArray(new String[normalizedRoles.size()]);
        }
        return roles;
    }
}

