/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.client.secure.client;

import java.rmi.RemoteException;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.airavata.security.util.TrustStoreManager;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.identity.oauth.stub.OAuthAdminServiceException;
import org.wso2.carbon.identity.oauth.stub.OAuthAdminServiceStub;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.utils.CarbonUtils;

public class OAuthAppRegisteringClient {
    private OAuthAdminServiceStub stub;
    private static final Logger logger = LoggerFactory.getLogger(OAuthAppRegisteringClient.class);

    public OAuthAppRegisteringClient(String auhorizationServerURL, String username, String password, ConfigurationContext configCtx) throws Exception {
        String serviceURL = auhorizationServerURL + "OAuthAdminService";
        try {
            this.stub = new OAuthAdminServiceStub(configCtx, serviceURL);
            CarbonUtils.setBasicAccessSecurityHeaders((String)username, (String)password, (boolean)true, (ServiceClient)this.stub._getServiceClient());
        }
        catch (AxisFault e) {
            logger.error("Error initializing OAuth2 Client");
            throw new Exception("Error initializing OAuth Client", e);
        }
    }

    public OAuthConsumerAppDTO registerApplication(String appName, String consumerId, String consumerSecret) throws AiravataSecurityException {
        try {
            OAuthConsumerAppDTO consumerAppDTO = new OAuthConsumerAppDTO();
            consumerAppDTO.setApplicationName(appName);
            consumerAppDTO.setOauthConsumerKey(consumerId);
            consumerAppDTO.setOauthConsumerSecret(consumerSecret);
            TrustStoreManager trustStoreManager = new TrustStoreManager();
            trustStoreManager.initializeTrustStoreManager("../../../../../airavata/modules/configuration/server/src/main/resources/client_truststore.jks", "airavata");
            this.stub.registerOAuthApplicationData(consumerAppDTO);
            return this.stub.getOAuthApplicationDataByAppName(appName);
        }
        catch (AxisFault axisFault) {
            axisFault.printStackTrace();
            throw new AiravataSecurityException("Error in registering the OAuth application.");
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new AiravataSecurityException("Error in registering the OAuth application.");
        }
        catch (OAuthAdminServiceException e) {
            e.printStackTrace();
            throw new AiravataSecurityException("Error in registering the OAuth application.");
        }
    }
}

