/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.security.oauth;

import java.rmi.RemoteException;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.identity.oauth2.stub.OAuth2TokenValidationServiceStub;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationRequestDTO_OAuth2AccessToken;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.utils.CarbonUtils;

public class DefaultOAuthClient {
    private OAuth2TokenValidationServiceStub stub;
    private static final Logger logger = LoggerFactory.getLogger(DefaultOAuthClient.class);
    public static final String BEARER_TOKEN_TYPE = "bearer";

    public DefaultOAuthClient(String auhorizationServerURL, String username, String password, ConfigurationContext configCtx) throws AiravataSecurityException {
        try {
            String serviceURL = auhorizationServerURL + "OAuth2TokenValidationService";
            this.stub = new OAuth2TokenValidationServiceStub(configCtx, serviceURL);
            CarbonUtils.setBasicAccessSecurityHeaders((String)username, (String)password, (boolean)true, (ServiceClient)this.stub._getServiceClient());
        }
        catch (AxisFault e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error initializing OAuth client.");
        }
    }

    public OAuth2TokenValidationResponseDTO validateAccessToken(String accessToken) throws AiravataSecurityException {
        try {
            OAuth2TokenValidationRequestDTO oauthReq = new OAuth2TokenValidationRequestDTO();
            OAuth2TokenValidationRequestDTO_OAuth2AccessToken token = new OAuth2TokenValidationRequestDTO_OAuth2AccessToken();
            token.setIdentifier(accessToken);
            token.setTokenType(BEARER_TOKEN_TYPE);
            oauthReq.setAccessToken(token);
            return this.stub.validate(oauthReq);
        }
        catch (RemoteException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException("Error in validating the OAuth access token.");
        }
    }
}

