/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.security.authzcache;

import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.airavata.service.security.authzcache.AuthzCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzCacheManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(AuthzCacheManagerFactory.class);

    public static AuthzCacheManager getAuthzCacheManager() throws AiravataSecurityException {
        try {
            Class<?> authzCacheManagerImpl = Class.forName(ServerSettings.getAuthzCacheManagerClassName());
            AuthzCacheManager authzCacheManager = (AuthzCacheManager)authzCacheManagerImpl.newInstance();
            return authzCacheManager;
        }
        catch (ClassNotFoundException e) {
            String error = "Authorization Cache Manager class could not be found.";
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException(error);
        }
        catch (ApplicationSettingsException e) {
            String error = "Error in reading the configuration related to Authorization Cache Manager class.";
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException(error);
        }
        catch (InstantiationException e) {
            String error = "Error in instantiating the Authorization Cache Manager class.";
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException(error);
        }
        catch (IllegalAccessException e) {
            String error = "Error in instantiating the Authorization Cache Manager class.";
            logger.error(e.getMessage(), (Throwable)e);
            throw new AiravataSecurityException(error);
        }
    }
}

