/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.cloud.aurora.util;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.airavata.cloud.aurora.client.AuroraSchedulerClientFactory;
import org.apache.airavata.cloud.aurora.client.bean.GetJobsResponseBean;
import org.apache.airavata.cloud.aurora.client.bean.IdentityBean;
import org.apache.airavata.cloud.aurora.client.bean.JobConfigBean;
import org.apache.airavata.cloud.aurora.client.bean.JobDetailsResponseBean;
import org.apache.airavata.cloud.aurora.client.bean.JobKeyBean;
import org.apache.airavata.cloud.aurora.client.bean.PendingJobReasonBean;
import org.apache.airavata.cloud.aurora.client.bean.ProcessBean;
import org.apache.airavata.cloud.aurora.client.bean.ResourceBean;
import org.apache.airavata.cloud.aurora.client.bean.ResponseBean;
import org.apache.airavata.cloud.aurora.client.bean.ServerInfoBean;
import org.apache.airavata.cloud.aurora.client.sdk.ExecutorConfig;
import org.apache.airavata.cloud.aurora.client.sdk.Identity;
import org.apache.airavata.cloud.aurora.client.sdk.JobConfiguration;
import org.apache.airavata.cloud.aurora.client.sdk.JobKey;
import org.apache.airavata.cloud.aurora.client.sdk.ReadOnlyScheduler;
import org.apache.airavata.cloud.aurora.client.sdk.Resource;
import org.apache.airavata.cloud.aurora.client.sdk.Response;
import org.apache.airavata.cloud.aurora.client.sdk.TaskConfig;
import org.apache.airavata.cloud.aurora.util.ResponseCodeEnum;
import org.apache.airavata.cloud.aurora.util.ResponseResultType;
import org.apache.airavata.common.utils.ServerSettings;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuroraThriftClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(AuroraThriftClientUtil.class);

    public static String getExecutorConfigJson(JobConfigBean jobConfig) throws Exception {
        String exeConfigJson = null;
        try {
            InputStream resourceAsStream = AuroraThriftClientUtil.class.getClassLoader().getResourceAsStream(ServerSettings.getAuroraExecutorConfigTemplateFileName());
            JSONObject exeConfig = new JSONObject(new JSONTokener(resourceAsStream));
            if (exeConfig != null) {
                exeConfig.put("environment", (Object)jobConfig.getJob().getEnvironment());
                exeConfig.put("name", (Object)jobConfig.getJob().getName());
                exeConfig.put("role", (Object)jobConfig.getJob().getRole());
                exeConfig.put("cluster", (Object)jobConfig.getCluster());
                exeConfig.put("max_task_failures", jobConfig.getMaxTaskFailures());
                exeConfig.put("service", jobConfig.isService());
                exeConfig.getJSONObject("task").put("name", (Object)jobConfig.getTaskConfig().getTaskName());
                exeConfig.getJSONObject("task").getJSONObject("resources").put("cpu", jobConfig.getTaskConfig().getResources().getNumCpus());
                exeConfig.getJSONObject("task").getJSONObject("resources").put("disk", jobConfig.getTaskConfig().getResources().getDiskMb() * 1024L * 1024L);
                exeConfig.getJSONObject("task").getJSONObject("resources").put("ram", jobConfig.getTaskConfig().getResources().getRamMb() * 1024L * 1024L);
                for (ProcessBean process : jobConfig.getTaskConfig().getProcesses()) {
                    exeConfig.getJSONObject("task").getJSONArray("constraints").getJSONObject(0).getJSONArray("order").put((Object)process.getName());
                    JSONObject processJson = new JSONObject();
                    processJson.put("final", process.isFinal()).put("daemon", process.isDaemon()).put("name", (Object)process.getName()).put("ephemeral", process.isEphemeral()).put("max_failures", process.getMax_failures()).put("min_duration", process.getMin_duration()).put("cmdline", (Object)process.getCmdLine());
                    exeConfig.getJSONObject("task").getJSONArray("processes").put((Object)processJson);
                }
                exeConfigJson = exeConfig.toString();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return exeConfigJson;
    }

    public static Set<Resource> getResourceSet(ResourceBean resources) throws Exception {
        HashSet<Resource> resourceSet = new HashSet<Resource>();
        try {
            if (resources == null) {
                throw new Exception("Resource Bean is NULL!");
            }
            Resource resource = new Resource();
            resource.setNumCpus(resources.getNumCpus());
            resourceSet.add(resource);
            resource = new Resource();
            resource.setDiskMb(resources.getDiskMb());
            resourceSet.add(resource);
            resource = new Resource();
            resource.setRamMb(resources.getRamMb());
            resourceSet.add(resource);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return resourceSet;
    }

    public static ExecutorConfig getExecutorConfig(String exeConfigJson) throws Exception {
        ExecutorConfig exeConfig = null;
        try {
            String executorName = ServerSettings.getAuroraExecutorName();
            if (exeConfigJson == null) {
                throw new Exception("Aurora Executor Config Data is NULL!");
            }
            exeConfig = new ExecutorConfig(executorName, exeConfigJson);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return exeConfig;
    }

    public static JobKey getAuroraJobKey(JobKeyBean jobKeyBean) throws Exception {
        JobKey jobKey = null;
        try {
            if (jobKeyBean == null) {
                throw new Exception("JobKey Bean is NULL!");
            }
            jobKey = new JobKey(jobKeyBean.getRole(), jobKeyBean.getEnvironment(), jobKeyBean.getName());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return jobKey;
    }

    public static Identity getAuroraIdentity(IdentityBean identityBean) throws Exception {
        Identity owner = null;
        try {
            if (identityBean == null) {
                throw new Exception("Identity Bean is NULL!");
            }
            owner = new Identity(identityBean.getUser());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return owner;
    }

    public static JobConfiguration getAuroraJobConfig(JobConfigBean jobConfigBean) throws Exception {
        JobConfiguration jobConfig = null;
        try {
            if (jobConfigBean == null || jobConfigBean.getTaskConfig() == null) {
                throw new Exception("JobConfig, TaskConfig Bean is/are NULL!");
            }
            JobKey jobKey = AuroraThriftClientUtil.getAuroraJobKey(jobConfigBean.getJob());
            Identity owner = AuroraThriftClientUtil.getAuroraIdentity(jobConfigBean.getOwner());
            TaskConfig taskConfig = new TaskConfig();
            taskConfig.setJob(jobKey);
            taskConfig.setOwner(owner);
            taskConfig.setIsService(jobConfigBean.isService());
            taskConfig.setNumCpus(jobConfigBean.getTaskConfig().getResources().getNumCpus());
            taskConfig.setRamMb(jobConfigBean.getTaskConfig().getResources().getRamMb());
            taskConfig.setDiskMb(jobConfigBean.getTaskConfig().getResources().getDiskMb());
            taskConfig.setPriority(jobConfigBean.getPriority());
            taskConfig.setMaxTaskFailures(jobConfigBean.getMaxTaskFailures());
            taskConfig.setResources(AuroraThriftClientUtil.getResourceSet(jobConfigBean.getTaskConfig().getResources()));
            taskConfig.setExecutorConfig(AuroraThriftClientUtil.getExecutorConfig(AuroraThriftClientUtil.getExecutorConfigJson(jobConfigBean)));
            jobConfig = new JobConfiguration(jobKey, owner, null, taskConfig, jobConfigBean.getInstances());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return jobConfig;
    }

    public static ResponseBean getResponseBean(Response response, ResponseResultType resultType) {
        switch (resultType) {
            case GET_JOBS: {
                return AuroraThriftClientUtil.getJobsResponseBean(response);
            }
            case GET_JOB_DETAILS: {
                return AuroraThriftClientUtil.getJobDetailsResponseBean(response);
            }
            case GET_PENDING_JOB_REASON: {
                return AuroraThriftClientUtil.getPendingJobReasonBean(response);
            }
        }
        return AuroraThriftClientUtil.getJobResponse(response);
    }

    private static JobDetailsResponseBean getJobDetailsResponseBean(Response response) {
        JobDetailsResponseBean responseBean = null;
        if (response != null) {
            responseBean = new JobDetailsResponseBean(AuroraThriftClientUtil.getJobResponse(response));
            responseBean.setTasks(response.getResult().getScheduleStatusResult().getTasks());
        }
        return responseBean;
    }

    private static PendingJobReasonBean getPendingJobReasonBean(Response response) {
        PendingJobReasonBean responseBean = null;
        if (response != null) {
            responseBean = new PendingJobReasonBean(AuroraThriftClientUtil.getJobResponse(response));
            responseBean.setReasons(response.getResult().getGetPendingReasonResult().getReasons());
        }
        return responseBean;
    }

    private static GetJobsResponseBean getJobsResponseBean(Response response) {
        GetJobsResponseBean responseBean = null;
        if (response != null) {
            responseBean = new GetJobsResponseBean(AuroraThriftClientUtil.getJobResponse(response));
        }
        return responseBean;
    }

    private static ResponseBean getJobResponse(Response response) {
        ResponseBean responseBean = null;
        if (response != null) {
            responseBean = new ResponseBean();
            responseBean.setResponseCode(ResponseCodeEnum.findByValue(response.getResponseCode().getValue()));
            ServerInfoBean serverInfo = new ServerInfoBean(response.getServerInfo().getClusterName(), response.getServerInfo().getStatsUrlPrefix());
            responseBean.setServerInfo(serverInfo);
        }
        return responseBean;
    }

    public static boolean isSchedulerHostReachable(String connectionUrl, int connectionTimeout) {
        boolean isReachable = false;
        ReadOnlyScheduler.Client auroraSchedulerClient = null;
        try {
            auroraSchedulerClient = AuroraSchedulerClientFactory.createReadOnlySchedulerClient(connectionUrl, connectionTimeout);
            auroraSchedulerClient.getTierConfigs();
            isReachable = true;
        }
        catch (Exception ex) {
            logger.error("Timed-out connecting to URL: " + connectionUrl);
        }
        return isReachable;
    }

    public static void main(String[] args) throws Exception {
    }
}

