/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.cloud.aurora.client.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.cloud.aurora.client.sdk.CronCollisionPolicy;
import org.apache.airavata.cloud.aurora.client.sdk.Identity;
import org.apache.airavata.cloud.aurora.client.sdk.JobKey;
import org.apache.airavata.cloud.aurora.client.sdk.TaskConfig;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class JobConfiguration
implements TBase<JobConfiguration, _Fields>,
Serializable,
Cloneable,
Comparable<JobConfiguration> {
    private static final TStruct STRUCT_DESC = new TStruct("JobConfiguration");
    private static final TField KEY_FIELD_DESC = new TField("key", 12, 9);
    private static final TField OWNER_FIELD_DESC = new TField("owner", 12, 7);
    private static final TField CRON_SCHEDULE_FIELD_DESC = new TField("cronSchedule", 11, 4);
    private static final TField CRON_COLLISION_POLICY_FIELD_DESC = new TField("cronCollisionPolicy", 8, 5);
    private static final TField TASK_CONFIG_FIELD_DESC = new TField("taskConfig", 12, 6);
    private static final TField INSTANCE_COUNT_FIELD_DESC = new TField("instanceCount", 8, 8);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public JobKey key;
    public Identity owner;
    public String cronSchedule;
    public CronCollisionPolicy cronCollisionPolicy;
    public TaskConfig taskConfig;
    public int instanceCount;
    private static final int __INSTANCECOUNT_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public JobConfiguration() {
    }

    public JobConfiguration(JobKey key, Identity owner, CronCollisionPolicy cronCollisionPolicy, TaskConfig taskConfig, int instanceCount) {
        this();
        this.key = key;
        this.owner = owner;
        this.cronCollisionPolicy = cronCollisionPolicy;
        this.taskConfig = taskConfig;
        this.instanceCount = instanceCount;
        this.setInstanceCountIsSet(true);
    }

    public JobConfiguration(JobConfiguration other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetKey()) {
            this.key = new JobKey(other.key);
        }
        if (other.isSetOwner()) {
            this.owner = new Identity(other.owner);
        }
        if (other.isSetCronSchedule()) {
            this.cronSchedule = other.cronSchedule;
        }
        if (other.isSetCronCollisionPolicy()) {
            this.cronCollisionPolicy = other.cronCollisionPolicy;
        }
        if (other.isSetTaskConfig()) {
            this.taskConfig = new TaskConfig(other.taskConfig);
        }
        this.instanceCount = other.instanceCount;
    }

    public JobConfiguration deepCopy() {
        return new JobConfiguration(this);
    }

    public void clear() {
        this.key = null;
        this.owner = null;
        this.cronSchedule = null;
        this.cronCollisionPolicy = null;
        this.taskConfig = null;
        this.setInstanceCountIsSet(false);
        this.instanceCount = 0;
    }

    public JobKey getKey() {
        return this.key;
    }

    public JobConfiguration setKey(JobKey key) {
        this.key = key;
        return this;
    }

    public void unsetKey() {
        this.key = null;
    }

    public boolean isSetKey() {
        return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
        if (!value) {
            this.key = null;
        }
    }

    public Identity getOwner() {
        return this.owner;
    }

    public JobConfiguration setOwner(Identity owner) {
        this.owner = owner;
        return this;
    }

    public void unsetOwner() {
        this.owner = null;
    }

    public boolean isSetOwner() {
        return this.owner != null;
    }

    public void setOwnerIsSet(boolean value) {
        if (!value) {
            this.owner = null;
        }
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public JobConfiguration setCronSchedule(String cronSchedule) {
        this.cronSchedule = cronSchedule;
        return this;
    }

    public void unsetCronSchedule() {
        this.cronSchedule = null;
    }

    public boolean isSetCronSchedule() {
        return this.cronSchedule != null;
    }

    public void setCronScheduleIsSet(boolean value) {
        if (!value) {
            this.cronSchedule = null;
        }
    }

    public CronCollisionPolicy getCronCollisionPolicy() {
        return this.cronCollisionPolicy;
    }

    public JobConfiguration setCronCollisionPolicy(CronCollisionPolicy cronCollisionPolicy) {
        this.cronCollisionPolicy = cronCollisionPolicy;
        return this;
    }

    public void unsetCronCollisionPolicy() {
        this.cronCollisionPolicy = null;
    }

    public boolean isSetCronCollisionPolicy() {
        return this.cronCollisionPolicy != null;
    }

    public void setCronCollisionPolicyIsSet(boolean value) {
        if (!value) {
            this.cronCollisionPolicy = null;
        }
    }

    public TaskConfig getTaskConfig() {
        return this.taskConfig;
    }

    public JobConfiguration setTaskConfig(TaskConfig taskConfig) {
        this.taskConfig = taskConfig;
        return this;
    }

    public void unsetTaskConfig() {
        this.taskConfig = null;
    }

    public boolean isSetTaskConfig() {
        return this.taskConfig != null;
    }

    public void setTaskConfigIsSet(boolean value) {
        if (!value) {
            this.taskConfig = null;
        }
    }

    public int getInstanceCount() {
        return this.instanceCount;
    }

    public JobConfiguration setInstanceCount(int instanceCount) {
        this.instanceCount = instanceCount;
        this.setInstanceCountIsSet(true);
        return this;
    }

    public void unsetInstanceCount() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetInstanceCount() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setInstanceCountIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case KEY: {
                if (value == null) {
                    this.unsetKey();
                    break;
                }
                this.setKey((JobKey)value);
                break;
            }
            case OWNER: {
                if (value == null) {
                    this.unsetOwner();
                    break;
                }
                this.setOwner((Identity)value);
                break;
            }
            case CRON_SCHEDULE: {
                if (value == null) {
                    this.unsetCronSchedule();
                    break;
                }
                this.setCronSchedule((String)value);
                break;
            }
            case CRON_COLLISION_POLICY: {
                if (value == null) {
                    this.unsetCronCollisionPolicy();
                    break;
                }
                this.setCronCollisionPolicy((CronCollisionPolicy)((Object)value));
                break;
            }
            case TASK_CONFIG: {
                if (value == null) {
                    this.unsetTaskConfig();
                    break;
                }
                this.setTaskConfig((TaskConfig)value);
                break;
            }
            case INSTANCE_COUNT: {
                if (value == null) {
                    this.unsetInstanceCount();
                    break;
                }
                this.setInstanceCount((Integer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case KEY: {
                return this.getKey();
            }
            case OWNER: {
                return this.getOwner();
            }
            case CRON_SCHEDULE: {
                return this.getCronSchedule();
            }
            case CRON_COLLISION_POLICY: {
                return this.getCronCollisionPolicy();
            }
            case TASK_CONFIG: {
                return this.getTaskConfig();
            }
            case INSTANCE_COUNT: {
                return this.getInstanceCount();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case KEY: {
                return this.isSetKey();
            }
            case OWNER: {
                return this.isSetOwner();
            }
            case CRON_SCHEDULE: {
                return this.isSetCronSchedule();
            }
            case CRON_COLLISION_POLICY: {
                return this.isSetCronCollisionPolicy();
            }
            case TASK_CONFIG: {
                return this.isSetTaskConfig();
            }
            case INSTANCE_COUNT: {
                return this.isSetInstanceCount();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof JobConfiguration) {
            return this.equals((JobConfiguration)that);
        }
        return false;
    }

    public boolean equals(JobConfiguration that) {
        if (that == null) {
            return false;
        }
        boolean this_present_key = this.isSetKey();
        boolean that_present_key = that.isSetKey();
        if (this_present_key || that_present_key) {
            if (!this_present_key || !that_present_key) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
        }
        boolean this_present_owner = this.isSetOwner();
        boolean that_present_owner = that.isSetOwner();
        if (this_present_owner || that_present_owner) {
            if (!this_present_owner || !that_present_owner) {
                return false;
            }
            if (!this.owner.equals(that.owner)) {
                return false;
            }
        }
        boolean this_present_cronSchedule = this.isSetCronSchedule();
        boolean that_present_cronSchedule = that.isSetCronSchedule();
        if (this_present_cronSchedule || that_present_cronSchedule) {
            if (!this_present_cronSchedule || !that_present_cronSchedule) {
                return false;
            }
            if (!this.cronSchedule.equals(that.cronSchedule)) {
                return false;
            }
        }
        boolean this_present_cronCollisionPolicy = this.isSetCronCollisionPolicy();
        boolean that_present_cronCollisionPolicy = that.isSetCronCollisionPolicy();
        if (this_present_cronCollisionPolicy || that_present_cronCollisionPolicy) {
            if (!this_present_cronCollisionPolicy || !that_present_cronCollisionPolicy) {
                return false;
            }
            if (!this.cronCollisionPolicy.equals((Object)that.cronCollisionPolicy)) {
                return false;
            }
        }
        boolean this_present_taskConfig = this.isSetTaskConfig();
        boolean that_present_taskConfig = that.isSetTaskConfig();
        if (this_present_taskConfig || that_present_taskConfig) {
            if (!this_present_taskConfig || !that_present_taskConfig) {
                return false;
            }
            if (!this.taskConfig.equals(that.taskConfig)) {
                return false;
            }
        }
        boolean this_present_instanceCount = true;
        boolean that_present_instanceCount = true;
        if (this_present_instanceCount || that_present_instanceCount) {
            if (!this_present_instanceCount || !that_present_instanceCount) {
                return false;
            }
            if (this.instanceCount != that.instanceCount) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_key = this.isSetKey();
        list.add(present_key);
        if (present_key) {
            list.add(this.key);
        }
        boolean present_owner = this.isSetOwner();
        list.add(present_owner);
        if (present_owner) {
            list.add(this.owner);
        }
        boolean present_cronSchedule = this.isSetCronSchedule();
        list.add(present_cronSchedule);
        if (present_cronSchedule) {
            list.add(this.cronSchedule);
        }
        boolean present_cronCollisionPolicy = this.isSetCronCollisionPolicy();
        list.add(present_cronCollisionPolicy);
        if (present_cronCollisionPolicy) {
            list.add(this.cronCollisionPolicy.getValue());
        }
        boolean present_taskConfig = this.isSetTaskConfig();
        list.add(present_taskConfig);
        if (present_taskConfig) {
            list.add(this.taskConfig);
        }
        boolean present_instanceCount = true;
        list.add(present_instanceCount);
        if (present_instanceCount) {
            list.add(this.instanceCount);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(JobConfiguration other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(other.isSetKey());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey() && (lastComparison = TBaseHelper.compareTo((Comparable)this.key, (Comparable)other.key)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOwner()).compareTo(other.isSetOwner());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOwner() && (lastComparison = TBaseHelper.compareTo((Comparable)this.owner, (Comparable)other.owner)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCronSchedule()).compareTo(other.isSetCronSchedule());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCronSchedule() && (lastComparison = TBaseHelper.compareTo((String)this.cronSchedule, (String)other.cronSchedule)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCronCollisionPolicy()).compareTo(other.isSetCronCollisionPolicy());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCronCollisionPolicy() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.cronCollisionPolicy), (Comparable)((Object)other.cronCollisionPolicy))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTaskConfig()).compareTo(other.isSetTaskConfig());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskConfig() && (lastComparison = TBaseHelper.compareTo((Comparable)this.taskConfig, (Comparable)other.taskConfig)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetInstanceCount()).compareTo(other.isSetInstanceCount());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetInstanceCount() && (lastComparison = TBaseHelper.compareTo((int)this.instanceCount, (int)other.instanceCount)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JobConfiguration(");
        boolean first = true;
        sb.append("key:");
        if (this.key == null) {
            sb.append("null");
        } else {
            sb.append(this.key);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("owner:");
        if (this.owner == null) {
            sb.append("null");
        } else {
            sb.append(this.owner);
        }
        first = false;
        if (this.isSetCronSchedule()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("cronSchedule:");
            if (this.cronSchedule == null) {
                sb.append("null");
            } else {
                sb.append(this.cronSchedule);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("cronCollisionPolicy:");
        if (this.cronCollisionPolicy == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.cronCollisionPolicy);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("taskConfig:");
        if (this.taskConfig == null) {
            sb.append("null");
        } else {
            sb.append(this.taskConfig);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("instanceCount:");
        sb.append(this.instanceCount);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.key != null) {
            this.key.validate();
        }
        if (this.owner != null) {
            this.owner.validate();
        }
        if (this.taskConfig != null) {
            this.taskConfig.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new JobConfigurationStandardSchemeFactory());
        schemes.put(TupleScheme.class, new JobConfigurationTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.CRON_SCHEDULE};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.KEY, new FieldMetaData("key", 3, (FieldValueMetaData)new StructMetaData(12, JobKey.class)));
        tmpMap.put(_Fields.OWNER, new FieldMetaData("owner", 3, (FieldValueMetaData)new StructMetaData(12, Identity.class)));
        tmpMap.put(_Fields.CRON_SCHEDULE, new FieldMetaData("cronSchedule", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CRON_COLLISION_POLICY, new FieldMetaData("cronCollisionPolicy", 3, (FieldValueMetaData)new EnumMetaData(16, CronCollisionPolicy.class)));
        tmpMap.put(_Fields.TASK_CONFIG, new FieldMetaData("taskConfig", 3, (FieldValueMetaData)new StructMetaData(12, TaskConfig.class)));
        tmpMap.put(_Fields.INSTANCE_COUNT, new FieldMetaData("instanceCount", 3, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(JobConfiguration.class, metaDataMap);
    }

    private static class JobConfigurationTupleScheme
    extends TupleScheme<JobConfiguration> {
        private JobConfigurationTupleScheme() {
        }

        public void write(TProtocol prot, JobConfiguration struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetKey()) {
                optionals.set(0);
            }
            if (struct.isSetOwner()) {
                optionals.set(1);
            }
            if (struct.isSetCronSchedule()) {
                optionals.set(2);
            }
            if (struct.isSetCronCollisionPolicy()) {
                optionals.set(3);
            }
            if (struct.isSetTaskConfig()) {
                optionals.set(4);
            }
            if (struct.isSetInstanceCount()) {
                optionals.set(5);
            }
            oprot.writeBitSet(optionals, 6);
            if (struct.isSetKey()) {
                struct.key.write((TProtocol)oprot);
            }
            if (struct.isSetOwner()) {
                struct.owner.write((TProtocol)oprot);
            }
            if (struct.isSetCronSchedule()) {
                oprot.writeString(struct.cronSchedule);
            }
            if (struct.isSetCronCollisionPolicy()) {
                oprot.writeI32(struct.cronCollisionPolicy.getValue());
            }
            if (struct.isSetTaskConfig()) {
                struct.taskConfig.write((TProtocol)oprot);
            }
            if (struct.isSetInstanceCount()) {
                oprot.writeI32(struct.instanceCount);
            }
        }

        public void read(TProtocol prot, JobConfiguration struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(6);
            if (incoming.get(0)) {
                struct.key = new JobKey();
                struct.key.read((TProtocol)iprot);
                struct.setKeyIsSet(true);
            }
            if (incoming.get(1)) {
                struct.owner = new Identity();
                struct.owner.read((TProtocol)iprot);
                struct.setOwnerIsSet(true);
            }
            if (incoming.get(2)) {
                struct.cronSchedule = iprot.readString();
                struct.setCronScheduleIsSet(true);
            }
            if (incoming.get(3)) {
                struct.cronCollisionPolicy = CronCollisionPolicy.findByValue(iprot.readI32());
                struct.setCronCollisionPolicyIsSet(true);
            }
            if (incoming.get(4)) {
                struct.taskConfig = new TaskConfig();
                struct.taskConfig.read((TProtocol)iprot);
                struct.setTaskConfigIsSet(true);
            }
            if (incoming.get(5)) {
                struct.instanceCount = iprot.readI32();
                struct.setInstanceCountIsSet(true);
            }
        }
    }

    private static class JobConfigurationTupleSchemeFactory
    implements SchemeFactory {
        private JobConfigurationTupleSchemeFactory() {
        }

        public JobConfigurationTupleScheme getScheme() {
            return new JobConfigurationTupleScheme();
        }
    }

    private static class JobConfigurationStandardScheme
    extends StandardScheme<JobConfiguration> {
        private JobConfigurationStandardScheme() {
        }

        public void read(TProtocol iprot, JobConfiguration struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 9: {
                        if (schemeField.type == 12) {
                            struct.key = new JobKey();
                            struct.key.read(iprot);
                            struct.setKeyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 12) {
                            struct.owner = new Identity();
                            struct.owner.read(iprot);
                            struct.setOwnerIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.cronSchedule = iprot.readString();
                            struct.setCronScheduleIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.cronCollisionPolicy = CronCollisionPolicy.findByValue(iprot.readI32());
                            struct.setCronCollisionPolicyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 12) {
                            struct.taskConfig = new TaskConfig();
                            struct.taskConfig.read(iprot);
                            struct.setTaskConfigIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.instanceCount = iprot.readI32();
                            struct.setInstanceCountIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, JobConfiguration struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.cronSchedule != null && struct.isSetCronSchedule()) {
                oprot.writeFieldBegin(CRON_SCHEDULE_FIELD_DESC);
                oprot.writeString(struct.cronSchedule);
                oprot.writeFieldEnd();
            }
            if (struct.cronCollisionPolicy != null) {
                oprot.writeFieldBegin(CRON_COLLISION_POLICY_FIELD_DESC);
                oprot.writeI32(struct.cronCollisionPolicy.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.taskConfig != null) {
                oprot.writeFieldBegin(TASK_CONFIG_FIELD_DESC);
                struct.taskConfig.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.owner != null) {
                oprot.writeFieldBegin(OWNER_FIELD_DESC);
                struct.owner.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(INSTANCE_COUNT_FIELD_DESC);
            oprot.writeI32(struct.instanceCount);
            oprot.writeFieldEnd();
            if (struct.key != null) {
                oprot.writeFieldBegin(KEY_FIELD_DESC);
                struct.key.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class JobConfigurationStandardSchemeFactory
    implements SchemeFactory {
        private JobConfigurationStandardSchemeFactory() {
        }

        public JobConfigurationStandardScheme getScheme() {
            return new JobConfigurationStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        KEY(9, "key"),
        OWNER(7, "owner"),
        CRON_SCHEDULE(4, "cronSchedule"),
        CRON_COLLISION_POLICY(5, "cronCollisionPolicy"),
        TASK_CONFIG(6, "taskConfig"),
        INSTANCE_COUNT(8, "instanceCount");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 9: {
                    return KEY;
                }
                case 7: {
                    return OWNER;
                }
                case 4: {
                    return CRON_SCHEDULE;
                }
                case 5: {
                    return CRON_COLLISION_POLICY;
                }
                case 6: {
                    return TASK_CONFIG;
                }
                case 8: {
                    return INSTANCE_COUNT;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

