/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.coherence;

import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.store.IndexOutput;
import org.compass.needle.coherence.CoherenceDirectory;
import org.compass.needle.coherence.CoherenceDirectoryException;
import org.compass.needle.coherence.FileBucketKey;
import org.compass.needle.coherence.FileBucketValue;
import org.compass.needle.coherence.FileHeaderKey;
import org.compass.needle.coherence.FileHeaderValue;

class CoherenceMemIndexOutput
extends IndexOutput {
    private CoherenceDirectory dir;
    private String fileName;
    private FileBucketKey firstBucketKey;
    private FileBucketValue firstBucketValue;
    private HashMap<Object, Object> flushBuckets;
    private byte[] buffer;
    private int bufferPosition;
    private int currentBucketIndex;
    private long length;
    private long position;
    private boolean open;
    private boolean seekOccured;

    public CoherenceMemIndexOutput(CoherenceDirectory dir, String fileName) throws IOException {
        this.dir = dir;
        this.fileName = fileName;
        this.open = true;
        this.buffer = new byte[dir.getBucketSize()];
        this.flushBuckets = new HashMap();
        if (fileName.equals("segments.gen")) {
            dir.deleteFile(fileName);
        }
    }

    public void writeByte(byte b) throws IOException {
        if (this.bufferPosition == this.dir.getBucketSize()) {
            if (this.seekOccured) {
                throw new CoherenceDirectoryException(this.dir.getIndexName(), this.fileName, "Seek occured and overflowed first bucket");
            }
            this.flushBucket();
        }
        this.buffer[this.bufferPosition++] = b;
        if (!this.seekOccured) {
            ++this.length;
            ++this.position;
        }
    }

    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        if (!this.seekOccured) {
            this.position += (long)len;
            this.length += (long)len;
        }
        while (len > 0) {
            int remainInBuffer;
            if (this.bufferPosition == this.dir.getBucketSize()) {
                if (this.seekOccured) {
                    throw new CoherenceDirectoryException(this.dir.getIndexName(), this.fileName, "Seek occured and overflowed first bucket");
                }
                this.flushBucket();
            }
            int bytesToCopy = len < (remainInBuffer = this.dir.getBucketSize() - this.bufferPosition) ? len : remainInBuffer;
            System.arraycopy(b, offset, this.buffer, this.bufferPosition, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
            this.bufferPosition += bytesToCopy;
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.flushBucket();
        this.flushBuckets.put(this.firstBucketKey, this.firstBucketValue);
        this.flushBuckets.put(new FileHeaderKey(this.dir.getIndexName(), this.fileName), new FileHeaderValue(System.currentTimeMillis(), this.length));
        this.forceFlushBuckets();
        this.buffer = null;
        this.firstBucketKey = null;
        this.firstBucketValue = null;
    }

    public long getFilePointer() {
        return this.position;
    }

    public void seek(long pos) throws IOException {
        if (pos >= (long)this.dir.getBucketSize()) {
            throw new CoherenceDirectoryException(this.dir.getIndexName(), this.fileName, "seek called outside of first bucket boundries");
        }
        if (this.firstBucketKey == null) {
            this.firstBucketKey = new FileBucketKey(this.dir.getIndexName(), this.fileName, 0L);
            this.firstBucketValue = new FileBucketValue(new byte[this.bufferPosition]);
            System.arraycopy(this.buffer, 0, this.firstBucketValue.getData(), 0, this.bufferPosition);
        } else if (!this.seekOccured) {
            this.flushBucket(this.currentBucketIndex, this.buffer, this.bufferPosition);
        }
        this.position = pos;
        this.currentBucketIndex = 0;
        this.bufferPosition = (int)pos;
        this.buffer = this.firstBucketValue.getData();
        this.seekOccured = true;
    }

    public long length() throws IOException {
        return this.length;
    }

    private void flushBucket() throws IOException {
        if (this.currentBucketIndex == 0) {
            if (this.firstBucketKey == null) {
                this.firstBucketKey = new FileBucketKey(this.dir.getIndexName(), this.fileName, 0L);
                this.firstBucketValue = new FileBucketValue(new byte[this.bufferPosition]);
                System.arraycopy(this.buffer, 0, this.firstBucketValue.getData(), 0, this.bufferPosition);
            }
        } else if (this.bufferPosition > 0) {
            this.flushBucket(this.currentBucketIndex, this.buffer, this.bufferPosition);
        }
        ++this.currentBucketIndex;
        this.bufferPosition = 0;
    }

    private void flushBucket(long bucketIndex, byte[] buffer, int length) throws IOException {
        FileBucketKey fileBucketKey = new FileBucketKey(this.dir.getIndexName(), this.fileName, bucketIndex);
        FileBucketValue fileBucketValue = new FileBucketValue(new byte[length]);
        System.arraycopy(buffer, 0, fileBucketValue.getData(), 0, length);
        this.flushBuckets.put(fileBucketKey, fileBucketValue);
        if (this.flushBuckets.size() >= this.dir.getFlushRate()) {
            this.forceFlushBuckets();
        }
    }

    private void forceFlushBuckets() throws IOException {
        if (this.flushBuckets.size() == 0) {
            return;
        }
        try {
            this.dir.getCache().putAll(this.flushBuckets);
        }
        catch (Exception e) {
            throw new CoherenceDirectoryException(this.dir.getIndexName(), this.fileName, "Failed to flush buckets", e);
        }
        finally {
            this.flushBuckets.clear();
        }
    }
}

