/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.workflow.catalog.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.workflow.catalog.model.Workflow;
import org.apache.airavata.registry.core.workflow.catalog.model.WorkflowInput;
import org.apache.airavata.registry.core.workflow.catalog.model.WorkflowInput_PK;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowCatAbstractResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowCatalogResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowResource;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogJPAUtils;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogQueryGenerator;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogResourceType;
import org.apache.airavata.registry.cpi.WorkflowCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowInputResource
extends WorkflowCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowInputResource.class);
    private String wfTemplateId;
    private String inputKey;
    private String dataType;
    private String inputVal;
    private String metadata;
    private String appArgument;
    private String userFriendlyDesc;
    private boolean standardInput;
    private int inputOrder;
    private boolean isRequired;
    private boolean requiredToCMD;
    private boolean dataStaged;
    private WorkflowResource workflowResource;

    @Override
    public void remove(Object identifier) throws WorkflowCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new WorkflowCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("WorkflowInput", new Object[0][]);
            generator.setParameter("templateID", ids.get("templateID"));
            generator.setParameter("inputKey", ids.get("inputKey"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public WorkflowCatalogResource get(Object identifier) throws WorkflowCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new WorkflowCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("WorkflowInput", new Object[0][]);
            generator.setParameter("templateID", ids.get("templateID"));
            generator.setParameter("inputKey", ids.get("inputKey"));
            Query q = generator.selectQuery(em);
            WorkflowInput workflowInput = (WorkflowInput)q.getSingleResult();
            WorkflowInputResource workflowInputResource = (WorkflowInputResource)WorkflowCatalogJPAUtils.getResource(WorkflowCatalogResourceType.WORKFLOW_INPUT, workflowInput);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            WorkflowInputResource workflowInputResource2 = workflowInputResource;
            return workflowInputResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<WorkflowCatalogResource> get(String fieldName, Object value) throws WorkflowCatalogException {
        ArrayList<WorkflowCatalogResource> wfInputResources = new ArrayList<WorkflowCatalogResource>();
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("WorkflowInput", new Object[0][]);
            if (fieldName.equals("templateID")) {
                generator.setParameter("templateID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        WorkflowInput workflowInput = (WorkflowInput)result;
                        WorkflowInputResource workflowInputResource = (WorkflowInputResource)WorkflowCatalogJPAUtils.getResource(WorkflowCatalogResourceType.WORKFLOW_INPUT, workflowInput);
                        wfInputResources.add(workflowInputResource);
                    }
                }
            } else if (fieldName.equals("inputKey")) {
                generator.setParameter("inputKey", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        WorkflowInput workflowInput = (WorkflowInput)result;
                        WorkflowInputResource workflowInputResource = (WorkflowInputResource)WorkflowCatalogJPAUtils.getResource(WorkflowCatalogResourceType.WORKFLOW_INPUT, workflowInput);
                        wfInputResources.add(workflowInputResource);
                    }
                }
            } else if (fieldName.equals("dataType")) {
                generator.setParameter("dataType", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        WorkflowInput workflowInput = (WorkflowInput)result;
                        WorkflowInputResource workflowInputResource = (WorkflowInputResource)WorkflowCatalogJPAUtils.getResource(WorkflowCatalogResourceType.WORKFLOW_INPUT, workflowInput);
                        wfInputResources.add(workflowInputResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for WFInput Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for WFInput Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return wfInputResources;
    }

    @Override
    public List<WorkflowCatalogResource> getAll() throws WorkflowCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws WorkflowCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws WorkflowCatalogException {
        ArrayList<String> wfInputResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowCatalogQueryGenerator generator = new WorkflowCatalogQueryGenerator("WorkflowInput", new Object[0][]);
            if (fieldName.equals("templateID")) {
                generator.setParameter("templateID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        WorkflowInput workflowInput = (WorkflowInput)result;
                        wfInputResourceIDs.add(workflowInput.getTemplateID());
                    }
                }
            } else if (fieldName.equals("inputKey")) {
                generator.setParameter("inputKey", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        WorkflowInput workflowInput = (WorkflowInput)result;
                        wfInputResourceIDs.add(workflowInput.getTemplateID());
                    }
                }
            } else if (fieldName.equals("dataType")) {
                generator.setParameter("dataType", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        WorkflowInput workflowInput = (WorkflowInput)result;
                        wfInputResourceIDs.add(workflowInput.getTemplateID());
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for WFInput resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for WFInput Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return wfInputResourceIDs;
    }

    @Override
    public void save() throws WorkflowCatalogException {
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            WorkflowInput existingWFInput = (WorkflowInput)em.find(WorkflowInput.class, (Object)new WorkflowInput_PK(this.wfTemplateId, this.inputKey));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = WorkflowCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowInput workflowInput = existingWFInput == null ? new WorkflowInput() : existingWFInput;
            workflowInput.setTemplateID(this.wfTemplateId);
            Workflow workflow = (Workflow)em.find(Workflow.class, (Object)this.wfTemplateId);
            workflowInput.setWorkflow(workflow);
            workflowInput.setDataType(this.dataType);
            workflowInput.setInputKey(this.inputKey);
            if (this.inputVal != null) {
                workflowInput.setInputVal(this.inputVal.toCharArray());
            }
            workflowInput.setMetadata(this.metadata);
            workflowInput.setAppArgument(this.appArgument);
            workflowInput.setUserFriendlyDesc(this.userFriendlyDesc);
            workflowInput.setStandardInput(this.standardInput);
            workflowInput.setRequiredToCMD(this.requiredToCMD);
            workflowInput.setRequired(this.isRequired);
            workflowInput.setDataStaged(this.dataStaged);
            if (existingWFInput == null) {
                em.persist((Object)workflowInput);
            } else {
                em.merge((Object)workflowInput);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws WorkflowCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new WorkflowCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = WorkflowCatalogJPAUtils.getEntityManager();
            WorkflowInput workflowInput = (WorkflowInput)em.find(WorkflowInput.class, (Object)new WorkflowInput_PK((String)ids.get("templateID"), (String)ids.get("inputKey")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = workflowInput != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new WorkflowCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getWfTemplateId() {
        return this.wfTemplateId;
    }

    public void setWfTemplateId(String wfTemplateId) {
        this.wfTemplateId = wfTemplateId;
    }

    public String getInputKey() {
        return this.inputKey;
    }

    public void setInputKey(String inputKey) {
        this.inputKey = inputKey;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getInputVal() {
        return this.inputVal;
    }

    public void setInputVal(String inputVal) {
        this.inputVal = inputVal;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getAppArgument() {
        return this.appArgument;
    }

    public void setAppArgument(String appArgument) {
        this.appArgument = appArgument;
    }

    public String getUserFriendlyDesc() {
        return this.userFriendlyDesc;
    }

    public void setUserFriendlyDesc(String userFriendlyDesc) {
        this.userFriendlyDesc = userFriendlyDesc;
    }

    public WorkflowResource getWorkflowResource() {
        return this.workflowResource;
    }

    public void setWorkflowResource(WorkflowResource workflowResource) {
        this.workflowResource = workflowResource;
    }

    public boolean isStandardInput() {
        return this.standardInput;
    }

    public void setStandardInput(boolean standardInput) {
        this.standardInput = standardInput;
    }

    public int getInputOrder() {
        return this.inputOrder;
    }

    public void setInputOrder(int inputOrder) {
        this.inputOrder = inputOrder;
    }

    public boolean getRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public boolean getRequiredToCMD() {
        return this.requiredToCMD;
    }

    public void setRequiredToCMD(boolean requiredToCMD) {
        this.requiredToCMD = requiredToCMD;
    }

    public boolean isDataStaged() {
        return this.dataStaged;
    }

    public void setDataStaged(boolean dataStaged) {
        this.dataStaged = dataStaged;
    }
}

