/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentInput;
import org.apache.airavata.registry.core.experiment.catalog.model.ExperimentInputPK;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentInputResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentInputResource.class);
    private String experimentId;
    private String inputName;
    private String inputValue;
    private String dataType;
    private String applicationArgument;
    private boolean standardInput = false;
    private String userFriendlyDescription;
    private String metadata;
    private Integer inputOrder;
    private boolean isRequired;
    private boolean requiredToAddedToCmd;
    private boolean dataStaged = false;
    private String storageResourceId;
    private boolean isReadOnly;

    public String getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(String experimentId) {
        this.experimentId = experimentId;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public String getInputValue() {
        return this.inputValue;
    }

    public void setInputValue(String inputValue) {
        this.inputValue = inputValue;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getApplicationArgument() {
        return this.applicationArgument;
    }

    public void setApplicationArgument(String applicationArgument) {
        this.applicationArgument = applicationArgument;
    }

    public boolean getStandardInput() {
        return this.standardInput;
    }

    public void setStandardInput(boolean standardInput) {
        this.standardInput = standardInput;
    }

    public String getUserFriendlyDescription() {
        return this.userFriendlyDescription;
    }

    public void setUserFriendlyDescription(String userFriendlyDescription) {
        this.userFriendlyDescription = userFriendlyDescription;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public Integer getInputOrder() {
        return this.inputOrder;
    }

    public void setInputOrder(Integer inputOrder) {
        this.inputOrder = inputOrder;
    }

    public boolean getIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public boolean getRequiredToAddedToCmd() {
        return this.requiredToAddedToCmd;
    }

    public void setRequiredToAddedToCmd(boolean requiredToAddedToCmd) {
        this.requiredToAddedToCmd = requiredToAddedToCmd;
    }

    public String getStorageResourceId() {
        return this.storageResourceId;
    }

    public void setStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
    }

    public boolean getDataStaged() {
        return this.dataStaged;
    }

    public void setDataStaged(boolean dataStaged) {
        this.dataStaged = dataStaged;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for process input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for process input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for process input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for process input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            if (this.experimentId == null) {
                throw new RegistryException("Does not have the experiment id");
            }
            ExperimentInputPK experimentInputPK = new ExperimentInputPK();
            experimentInputPK.setExperimentId(this.experimentId);
            experimentInputPK.setInputName(this.inputName);
            ExperimentInput existingExpInput = (ExperimentInput)em.find(ExperimentInput.class, (Object)experimentInputPK);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            ExperimentInput experimentInput = existingExpInput == null ? new ExperimentInput() : existingExpInput;
            experimentInput.setExperimentId(this.experimentId);
            experimentInput.setInputName(this.inputName);
            experimentInput.setInputValue(this.inputValue);
            experimentInput.setDataType(this.dataType);
            experimentInput.setApplicationArgument(this.applicationArgument);
            experimentInput.setStandardInput(this.standardInput);
            experimentInput.setUserFriendlyDescription(this.userFriendlyDescription);
            experimentInput.setMetadata(this.metadata);
            experimentInput.setInputOrder(this.inputOrder);
            experimentInput.setIsRequired(this.isRequired);
            experimentInput.setRequiredToAddedToCmd(this.requiredToAddedToCmd);
            experimentInput.setDataStaged(this.dataStaged);
            experimentInput.setStorageResourceId(this.storageResourceId);
            experimentInput.setIsReadOnly(this.isReadOnly);
            if (existingExpInput == null) {
                em.persist((Object)experimentInput);
            } else {
                em.merge((Object)experimentInput);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

