/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.config;

import javax.xml.ws.soap.MTOM;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.feature.ServerConfigurator;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.registry.ServerConfiguratorRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MTOMConfigurator
implements ServerConfigurator {
    private static Log log = LogFactory.getLog(MTOMConfigurator.class);

    public void configure(EndpointDescription endpointDescription) {
        MTOM mtomAnnoation = (MTOM)((EndpointDescriptionJava)((Object)endpointDescription)).getAnnoFeature("http://www.w3.org/2004/08/soap/features/http-optimization");
        AxisService service = endpointDescription.getAxisService();
        Parameter enableMTOM = new Parameter("enableMTOM", Boolean.FALSE);
        Parameter threshold = new Parameter("mtomThreshold", 0);
        if (mtomAnnoation == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("mtomAnnotationErr"));
        }
        if (mtomAnnoation.enabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Enabling MTOM via annotation.");
            }
            enableMTOM.setValue(Boolean.TRUE);
        }
        if (mtomAnnoation.threshold() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting MTOM threshold to [" + mtomAnnoation.threshold() + "]."));
            }
            threshold.setValue(mtomAnnoation.threshold());
        }
        try {
            service.addParameter(enableMTOM);
            service.addParameter(threshold);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("mtomEnableErr"), e);
        }
    }

    public boolean supports(String bindingId) {
        return ServerConfiguratorRegistry.isSOAPBinding(bindingId);
    }
}

