/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.httpclient;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.X509Credential;
import eu.unicore.security.canl.DefaultAuthnAndTrustConfiguration;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.httpclient.ETDClientSettings;
import eu.unicore.util.httpclient.HttpClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import eu.unicore.util.httpclient.ServerHostnameCheckingMode;
import eu.unicore.util.httpclient.SessionIDProvider;
import eu.unicore.util.httpclient.SessionIDProviderImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DefaultClientConfiguration
extends DefaultAuthnAndTrustConfiguration
implements IClientConfiguration {
    private String httpUser;
    private String httpPassword;
    private boolean sslAuthn;
    private boolean httpAuthn;
    private boolean messageLogging;
    private boolean useSecuritySessions = true;
    private String[] inHandlerClassNames;
    private String[] outHandlerClassNames;
    private ClassLoader classLoader;
    private boolean sslEnabled;
    private boolean doSignMessage;
    private int maxWSRetries = 1;
    private long retryDelay = 0L;
    private ETDClientSettings etdSettings = new ETDClientSettings();
    private Map<String, Object> extraSecurityTokens = new HashMap<String, Object>();
    private ServerHostnameCheckingMode serverHostnameCheckingMode = ServerHostnameCheckingMode.NONE;
    private HttpClientProperties httpClientProperties = new HttpClientProperties(new Properties());
    private final Map<Class<? extends PropertiesHelper>, PropertiesHelper> extraConfigurationHandlers = new HashMap<Class<? extends PropertiesHelper>, PropertiesHelper>();
    private SessionIDProvider sessionIDProvider = new SessionIDProviderImpl();

    public DefaultClientConfiguration() {
    }

    public DefaultClientConfiguration(X509CertChainValidatorExt validator, X509Credential credential) {
        super(validator, credential);
        this.sslAuthn = true;
        this.sslEnabled = true;
        this.etdSettings.setIssuerCertificateChain(credential.getCertificateChain());
    }

    @Override
    public void setCredential(X509Credential credential) {
        super.setCredential(credential);
        if (this.getCredential() != null) {
            this.etdSettings.setIssuerCertificateChain(credential.getCertificateChain());
        }
    }

    @Override
    public String getHttpUser() {
        return this.httpUser;
    }

    public void setHttpUser(String httpUser) {
        this.httpUser = httpUser;
    }

    @Override
    public String getHttpPassword() {
        return this.httpPassword;
    }

    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    @Override
    public boolean doSSLAuthn() {
        return this.sslAuthn;
    }

    public void setSslAuthn(boolean sslAuthn) {
        this.sslAuthn = sslAuthn;
    }

    @Override
    public boolean doHttpAuthn() {
        return this.httpAuthn;
    }

    public void setHttpAuthn(boolean httpAuthn) {
        this.httpAuthn = httpAuthn;
    }

    @Override
    public String[] getInHandlerClassNames() {
        return this.inHandlerClassNames;
    }

    public void setInHandlerClassNames(String[] inHandlerClassNames) {
        this.inHandlerClassNames = inHandlerClassNames;
    }

    @Override
    public String[] getOutHandlerClassNames() {
        return this.outHandlerClassNames;
    }

    public void setOutHandlerClassNames(String[] outHandlerClassNames) {
        this.outHandlerClassNames = outHandlerClassNames;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    @Override
    public boolean useSecuritySessions() {
        return this.useSecuritySessions;
    }

    public void setUseSecuritySessions(boolean useSecuritySessions) {
        this.useSecuritySessions = useSecuritySessions;
    }

    @Override
    public SessionIDProvider getSessionIDProvider() {
        return this.sessionIDProvider;
    }

    public void setSessionIDProvider(SessionIDProvider sessionIDProvider) {
        this.sessionIDProvider = sessionIDProvider;
    }

    @Override
    public boolean doSignMessage() {
        return this.doSignMessage;
    }

    public void setDoSignMessage(boolean doSignMessage) {
        this.doSignMessage = doSignMessage;
    }

    @Override
    public ETDClientSettings getETDSettings() {
        return this.etdSettings;
    }

    public void setEtdSettings(ETDClientSettings etdSettings) {
        this.etdSettings = etdSettings;
    }

    @Override
    @Deprecated
    public Properties getExtraSettings() {
        return null;
    }

    @Deprecated
    public void setExtraSettings(Properties extraSettings) {
    }

    @Override
    public Map<String, Object> getExtraSecurityTokens() {
        return this.extraSecurityTokens;
    }

    public void setExtraSecurityTokens(Map<String, Object> extraSecurityTokens) {
        this.extraSecurityTokens = extraSecurityTokens;
    }

    @Override
    public ServerHostnameCheckingMode getServerHostnameCheckingMode() {
        return this.serverHostnameCheckingMode;
    }

    public void setServerHostnameCheckingMode(ServerHostnameCheckingMode serverHostnameCheckingMode) {
        this.serverHostnameCheckingMode = serverHostnameCheckingMode;
    }

    public void setMessageLogging(boolean what) {
        this.messageLogging = what;
    }

    @Override
    public boolean isMessageLogging() {
        return this.messageLogging;
    }

    @Override
    public DefaultClientConfiguration clone() {
        DefaultClientConfiguration ret = (DefaultClientConfiguration)super.clone();
        this.cloneTo(ret);
        return ret;
    }

    @Override
    public HttpClientProperties getHttpClientProperties() {
        return this.httpClientProperties;
    }

    public void setHttpClientProperties(HttpClientProperties httpClientProperties) {
        this.httpClientProperties = httpClientProperties;
    }

    @Override
    public void addConfigurationHandler(PropertiesHelper settings) {
        this.extraConfigurationHandlers.put(settings.getClass(), settings);
    }

    @Override
    public <T extends PropertiesHelper> T getConfigurationHandler(Class<T> key) {
        PropertiesHelper o = this.extraConfigurationHandlers.get(key);
        return (T)((PropertiesHelper)key.cast(o));
    }

    @Override
    public int getMaxWSRetries() {
        return this.maxWSRetries;
    }

    public void setMaxWSRetries(int max) {
        this.maxWSRetries = max;
    }

    @Override
    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long delay) {
        this.retryDelay = delay;
    }

    protected IClientConfiguration cloneTo(DefaultClientConfiguration ret) {
        ret.setClassLoader(this.classLoader);
        ret.setCredential(this.getCredential());
        ret.setDoSignMessage(this.doSignMessage);
        ret.setEtdSettings(this.etdSettings.clone());
        HashMap<String, Object> extra = new HashMap<String, Object>();
        extra.putAll(this.extraSecurityTokens);
        ret.setExtraSecurityTokens(extra);
        ret.setHttpAuthn(this.httpAuthn);
        ret.setHttpPassword(this.httpPassword);
        ret.setHttpUser(this.httpUser);
        ret.setInHandlerClassNames(this.inHandlerClassNames);
        ret.setOutHandlerClassNames(this.outHandlerClassNames);
        ret.setSslAuthn(this.sslAuthn);
        ret.setSslAuthn(this.sslAuthn);
        ret.setSslEnabled(this.sslEnabled);
        ret.setValidator(this.getValidator());
        ret.setServerHostnameCheckingMode(this.serverHostnameCheckingMode);
        ret.setHttpClientProperties(this.httpClientProperties.clone());
        ret.setMessageLogging(this.messageLogging);
        ret.setUseSecuritySessions(this.useSecuritySessions);
        ret.setSessionIDProvider(this.sessionIDProvider);
        ret.extraConfigurationHandlers.putAll(this.extraConfigurationHandlers);
        ret.setRetryDelay(this.retryDelay);
        ret.setMaxWSRetries(this.maxWSRetries);
        return ret;
    }
}

