/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.wsn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.NameAlreadyBoundException;
import javax.xml.namespace.QName;

public class Topic {
    private String namespace;
    private String name;
    private List<Topic> children = new ArrayList<Topic>();
    private QName[] messageFormats;

    public Topic() {
        this(null, null);
    }

    public Topic(QName qname) {
        this(qname == null ? null : qname.getNamespaceURI(), qname == null ? null : qname.getLocalPart());
    }

    public Topic(String name) {
        this(null, name);
    }

    public Topic(String namespace, String name) {
        this(namespace, name, null);
    }

    public Topic(String namespace, String name, Topic parent) {
        this(namespace, name, parent, new QName[0]);
    }

    public Topic(String namespace, String name, Topic parent, QName ... messageFormats) {
        if (parent == null) {
            this.namespace = namespace;
            this.name = name;
            this.messageFormats = messageFormats;
        } else {
            this.namespace = parent.getNamespace();
            this.name = parent.name;
            this.messageFormats = parent.messageFormats;
            Topic child = new Topic(namespace, name, null, messageFormats);
            this.children.add(child);
        }
    }

    public void addChild(Topic topic) throws NameAlreadyBoundException {
        if (this.getChild(topic.getName()) != null) {
            throw new NameAlreadyBoundException();
        }
        this.children.add(topic);
    }

    public void addChildren(Topic ... topics) {
        this.children.addAll(Arrays.asList(topics));
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Topic[] getChildren() {
        return this.children.toArray(new Topic[this.children.size()]);
    }

    public Topic getChild(String name) {
        if (name == null) {
            return null;
        }
        for (Topic child : this.getChildren()) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QName[] getMessageFormats() {
        return this.messageFormats;
    }

    public void setMessageFormats(QName[] messageFormats) {
        this.messageFormats = messageFormats;
    }

    public QName getQName() {
        return new QName(this.getNamespace(), this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getChildren());
        result = 31 * result + Arrays.hashCode(this.messageFormats);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Topic)) {
            return false;
        }
        Topic other = (Topic)obj;
        if (this.children == null) {
            if (other.children != null) {
                return false;
            }
        } else {
            if (other.children == null) {
                return false;
            }
            if (this.children.size() != other.children.size()) {
                return false;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                if (this.children.get(i).equals(other.children.get(i))) continue;
                return false;
            }
            return false;
        }
        if (!Arrays.equals(this.messageFormats, other.messageFormats)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
    }
}

