/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.security;

import de.fzj.unicore.uas.security.ProxyCertProperties;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.proxy.ProxyCertificate;
import eu.emi.security.authn.x509.proxy.ProxyCertificateOptions;
import eu.emi.security.authn.x509.proxy.ProxyGenerator;
import eu.unicore.security.wsutil.client.Configurable;
import eu.unicore.security.wsutil.client.DSigOutHandler;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.PEMWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProxyCertOutHandler
extends AbstractSoapInterceptor
implements Configurable {
    private static final Logger logger = Log.getLogger("unicore.security", ProxyCertOutHandler.class);
    protected IClientConfiguration sec;
    protected ProxyCertProperties props;
    private Element proxyHeaderAsJDOM = null;
    private long expiryInstant;
    private String pem;
    public static final String PROXY_NS = "http://www.unicore.eu/unicore6";
    public static final String PROXY = "Proxy";
    private static final QName headerQName = new QName("http://www.unicore.eu/unicore6", "Proxy");

    public ProxyCertOutHandler() {
        super("pre-protocol");
        this.getBefore().add(DSigOutHandler.class.getName());
    }

    @Override
    public synchronized void configure(IClientConfiguration sec) {
        this.sec = sec;
        this.pem = null;
        this.props = sec.getConfigurationHandler(ProxyCertProperties.class);
        if (this.props == null) {
            this.props = new ProxyCertProperties(new Properties());
        }
        try {
            this.pem = this.props.isSetFileName() ? this.readProxyFromFile(this.props.getFileValueAsString("file", false)) : this.generateProxy();
            StringBuilder sb = new StringBuilder();
            sb.append("<proxy:Proxy xmlns:proxy=\"http://www.unicore.eu/unicore6\">");
            sb.append(this.pem);
            sb.append("</proxy:Proxy>");
            this.proxyHeaderAsJDOM = DOMUtils.readXml((InputStream)new ByteArrayInputStream(sb.toString().getBytes())).getDocumentElement();
        }
        catch (Exception ce) {
            logger.error("Can't create Proxy header: ", ce);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("(Re-)initialised Proxy Outhandler");
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DOMUtils.writeXml((Node)this.proxyHeaderAsJDOM, (OutputStream)bos);
                logger.debug(bos.toString());
            }
            catch (Exception e) {
                logger.warn("", e);
            }
        }
    }

    protected String readProxyFromFile(String fileName) throws IOException {
        FileInputStream is = new FileInputStream(fileName);
        try {
            KeyStore ks = CertificateUtils.loadPEMKeystore((InputStream)is, (char[])null, (char[])"none".toCharArray());
            X509Certificate x509 = (X509Certificate)ks.getCertificate("default");
            logger.info("Read proxy from '" + fileName + "' valid till " + x509.getNotAfter());
            this.expiryInstant = x509.getNotAfter().getTime() - 21600000L;
            String string = FileUtils.readFileToString((File)new File(fileName));
            return string;
        }
        catch (KeyStoreException ex) {
            throw new IOException(ex);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    protected String generateProxy() throws Exception {
        X509Credential credential = this.sec.getCredential();
        ProxyCertificateOptions param = new ProxyCertificateOptions(credential.getCertificateChain());
        param.setLifetime(this.props.getLifetime());
        param.setKeyLength(this.props.getKeysize());
        ProxyCertificate proxy = ProxyGenerator.generate((ProxyCertificateOptions)param, (PrivateKey)credential.getKey());
        int lifetime = param.getLifetime();
        this.expiryInstant = proxy.getCertificateChain()[0].getNotAfter().getTime() - (long)(lifetime / 2 * 1000);
        ByteArrayOutputStream os = new ByteArrayOutputStream(10240);
        OutputStreamWriter ow = new OutputStreamWriter(os);
        PEMWriter pw = new PEMWriter((Writer)ow);
        pw.writeObject((Object)proxy.getCertificateChain()[0]);
        pw.writeObject((Object)proxy.getPrivateKey());
        pw.writeObject((Object)credential.getCertificate());
        pw.flush();
        ow.close();
        return os.toString("US-ASCII");
    }

    public Element getProxyHeader() {
        return this.proxyHeaderAsJDOM;
    }

    public synchronized void handleMessage(SoapMessage message) {
        if (!MessageUtils.isOutbound((Message)message)) {
            return;
        }
        if (this.proxyHeaderAsJDOM == null) {
            return;
        }
        if (System.currentTimeMillis() > this.expiryInstant) {
            this.configure(this.sec);
        }
        List h = message.getHeaders();
        Header header = new Header(headerQName, (Object)this.proxyHeaderAsJDOM);
        h.add(header);
    }

    String getPem() {
        return this.pem;
    }
}

