/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.fts.FiletransferOptions;
import de.fzj.unicore.uas.fts.ProgressListener;
import de.fzj.unicore.uas.fts.byteio.RandomByteIO;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import org.apache.log4j.Logger;
import org.ggf.schemas.byteio.x2005.x10.randomAccess.SizeDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class ByteIOBaseClient
extends FileTransferClient
implements FiletransferOptions.IChunked,
FiletransferOptions.IMonitorable {
    private static final Logger logger = Log.getLogger("unicore.client", JobClient.class);
    public static final int DEFAULT_CHUNKSIZE = 128000;
    public static final int DEFAULT_CHUNKSIZE_MTOM = 2560000;
    protected int chunksize = 128000;
    protected ProgressListener<Long> progressListener;
    protected boolean wantMTOM = true;
    private Boolean mtomAvailable = null;

    public ByteIOBaseClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
    }

    public ByteIOBaseClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(epr.getAddress().getStringValue(), epr, sec);
    }

    public long getSize() {
        try {
            SizeDocument sd = SizeDocument.Factory.parse(this.getResourceProperty(RandomByteIO.RPSize));
            return sd.getSize().longValue();
        }
        catch (Exception e) {
            Log.logException("Error getting file size.", e, logger);
            return -1L;
        }
    }

    @Override
    public void setChunksize(int chunksize) {
        this.chunksize = chunksize;
    }

    @Override
    public void setProgressListener(ProgressListener<Long> listener) {
        this.progressListener = listener;
    }

    public boolean supportsMTOM() throws Exception {
        if (this.mtomAvailable == null) {
            this.mtomAvailable = this.getResourceProperty(RandomByteIO.RPTransferMechanisms).contains("http://schemas.ggf.org/byteio/2005/10/transfer-mechanisms/mtom");
            if (this.mtomAvailable.booleanValue() && this.chunksize == 128000) {
                this.chunksize = 2560000;
            }
        }
        return this.mtomAvailable;
    }

    public void setWantMTOM(boolean wantMTOM) {
        this.wantMTOM = wantMTOM;
    }

    protected boolean isMTOMEnabled() throws Exception {
        return this.wantMTOM && this.supportsMTOM();
    }
}

