/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.File;
import java.io.FilenameFilter;
import java.security.cert.X509CRL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.stores.ResourceCRL;
import org.globus.gsi.stores.ResourceSecurityWrapperStore;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.util.GlobusResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCRLStore
extends ResourceSecurityWrapperStore<ResourceCRL, X509CRL> {
    private static CrlFilter filter = new CrlFilter();
    private static final int MIN_NAME_LENGTH = 3;
    private Log logger = LogFactory.getLog((String)this.getClass().getCanonicalName());

    @Override
    public ResourceCRL create(GlobusResource globusResource) throws ResourceStoreException {
        return new ResourceCRL(false, globusResource);
    }

    @Override
    protected Log getLog() {
        return this.logger;
    }

    @Override
    public FilenameFilter getDefaultFilenameFilter() {
        return filter;
    }

    public static class CrlFilter
    implements FilenameFilter {
        public boolean accept(File dir, String file) {
            if (file == null) {
                throw new IllegalArgumentException();
            }
            int length = file.length();
            return length > 3 && file.endsWith(".r09");
        }
    }
}

