/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.llom;

import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.llom.SOAPElement;
import org.apache.axiom.soap.impl.llom.SOAPEnvelopeImpl;

public abstract class SOAPBodyImpl
extends SOAPElement
implements SOAPBody,
OMConstants {
    private boolean hasSOAPFault = false;
    private boolean enableLookAhead = true;
    private boolean lookAheadAttempted = false;
    private boolean lookAheadSuccessful = false;
    private String lookAheadLocalName = null;
    private OMNamespace lookAheadNS = null;

    protected SOAPBodyImpl(String localName, OMNamespace ns, SOAPFactory factory) {
        super(localName, ns, factory);
    }

    public SOAPBodyImpl(SOAPEnvelope envelope, SOAPFactory factory) throws SOAPProcessingException {
        super((OMElement)envelope, "Body", true, factory);
    }

    public SOAPBodyImpl(SOAPEnvelope envelope, OMXMLParserWrapper builder, SOAPFactory factory) {
        super((OMElement)envelope, "Body", builder, factory);
    }

    @Override
    public abstract SOAPFault addFault(Exception var1) throws OMException;

    @Override
    public boolean hasFault() {
        OMNamespace ns;
        if (this.hasSOAPFault) {
            return true;
        }
        String name = this.getFirstElementLocalName();
        if ("Fault".equals(name) && (ns = this.getFirstElementNS()) != null && ("http://schemas.xmlsoap.org/soap/envelope/".equals(ns.getNamespaceURI()) || "http://www.w3.org/2003/05/soap-envelope".equals(ns.getNamespaceURI()))) {
            this.hasSOAPFault = true;
        }
        return this.hasSOAPFault;
    }

    @Override
    public SOAPFault getFault() {
        OMElement element = this.getFirstElement();
        if (this.hasSOAPFault) {
            return (SOAPFault)element;
        }
        if (element != null && "Fault".equals(element.getLocalName()) && ("http://schemas.xmlsoap.org/soap/envelope/".equals(element.getNamespace().getNamespaceURI()) || "http://www.w3.org/2003/05/soap-envelope".equals(element.getNamespace().getNamespaceURI()))) {
            this.hasSOAPFault = true;
            return (SOAPFault)element;
        }
        return null;
    }

    @Override
    public void addFault(SOAPFault soapFault) throws OMException {
        if (this.hasSOAPFault) {
            throw new OMException("SOAP Body already has a SOAP Fault and there can not be more than one SOAP fault");
        }
        this.addChild(soapFault);
        this.hasSOAPFault = true;
    }

    @Override
    protected void checkParent(OMElement parent) throws SOAPProcessingException {
        if (!(parent instanceof SOAPEnvelopeImpl)) {
            throw new SOAPProcessingException("Expecting an implementation of SOAP Envelope as the parent. But received some other implementation");
        }
    }

    @Override
    public OMNode detach() throws OMException {
        throw new SOAPProcessingException("Can not detach SOAP Body, SOAP Envelope must have a Body !!");
    }

    @Override
    public void buildNext() {
        int token;
        if (this.builder != null && (token = this.builder.next()) == 1) {
            this.enableLookAhead = false;
        }
    }

    private boolean hasLookahead() {
        if (!this.enableLookAhead) {
            return false;
        }
        if (this.lookAheadAttempted) {
            return this.lookAheadSuccessful;
        }
        this.lookAheadAttempted = true;
        StAXSOAPModelBuilder soapBuilder = (StAXSOAPModelBuilder)this.builder;
        if (soapBuilder != null && soapBuilder.isCache() && !soapBuilder.isCompleted() && !soapBuilder.isClosed()) {
            this.lookAheadSuccessful = soapBuilder.lookahead();
            if (this.lookAheadSuccessful) {
                this.lookAheadLocalName = soapBuilder.getName();
                String ns = soapBuilder.getNamespace();
                ns = ns == null ? "" : ns;
                this.lookAheadNS = this.factory.createOMNamespace(ns, soapBuilder.getPrefix());
            }
        }
        return this.lookAheadSuccessful;
    }

    @Override
    public OMNamespace getFirstElementNS() {
        if (this.hasLookahead()) {
            return this.lookAheadNS;
        }
        OMElement element = this.getFirstElement();
        if (element == null) {
            return null;
        }
        return element.getNamespace();
    }

    @Override
    public String getFirstElementLocalName() {
        if (this.hasLookahead()) {
            return this.lookAheadLocalName;
        }
        OMElement element = this.getFirstElement();
        if (element == null) {
            return null;
        }
        return element.getLocalName();
    }

    @Override
    public void addChild(OMNode child) {
        this.enableLookAhead = false;
        super.addChild(child);
    }
}

