/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model;

import com.amazonaws.services.cloudsearchv2.model.AlgorithmicStemming;
import java.io.Serializable;

public class AnalysisOptions
implements Serializable {
    private String synonyms;
    private String stopwords;
    private String stemmingDictionary;
    private String algorithmicStemming;

    public String getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(String synonyms) {
        this.synonyms = synonyms;
    }

    public AnalysisOptions withSynonyms(String synonyms) {
        this.synonyms = synonyms;
        return this;
    }

    public String getStopwords() {
        return this.stopwords;
    }

    public void setStopwords(String stopwords) {
        this.stopwords = stopwords;
    }

    public AnalysisOptions withStopwords(String stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    public String getStemmingDictionary() {
        return this.stemmingDictionary;
    }

    public void setStemmingDictionary(String stemmingDictionary) {
        this.stemmingDictionary = stemmingDictionary;
    }

    public AnalysisOptions withStemmingDictionary(String stemmingDictionary) {
        this.stemmingDictionary = stemmingDictionary;
        return this;
    }

    public String getAlgorithmicStemming() {
        return this.algorithmicStemming;
    }

    public void setAlgorithmicStemming(String algorithmicStemming) {
        this.algorithmicStemming = algorithmicStemming;
    }

    public AnalysisOptions withAlgorithmicStemming(String algorithmicStemming) {
        this.algorithmicStemming = algorithmicStemming;
        return this;
    }

    public void setAlgorithmicStemming(AlgorithmicStemming algorithmicStemming) {
        this.algorithmicStemming = algorithmicStemming.toString();
    }

    public AnalysisOptions withAlgorithmicStemming(AlgorithmicStemming algorithmicStemming) {
        this.algorithmicStemming = algorithmicStemming.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSynonyms() != null) {
            sb.append("Synonyms: " + this.getSynonyms() + ",");
        }
        if (this.getStopwords() != null) {
            sb.append("Stopwords: " + this.getStopwords() + ",");
        }
        if (this.getStemmingDictionary() != null) {
            sb.append("StemmingDictionary: " + this.getStemmingDictionary() + ",");
        }
        if (this.getAlgorithmicStemming() != null) {
            sb.append("AlgorithmicStemming: " + this.getAlgorithmicStemming());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSynonyms() == null ? 0 : this.getSynonyms().hashCode());
        hashCode = 31 * hashCode + (this.getStopwords() == null ? 0 : this.getStopwords().hashCode());
        hashCode = 31 * hashCode + (this.getStemmingDictionary() == null ? 0 : this.getStemmingDictionary().hashCode());
        hashCode = 31 * hashCode + (this.getAlgorithmicStemming() == null ? 0 : this.getAlgorithmicStemming().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisOptions)) {
            return false;
        }
        AnalysisOptions other = (AnalysisOptions)obj;
        if (other.getSynonyms() == null ^ this.getSynonyms() == null) {
            return false;
        }
        if (other.getSynonyms() != null && !other.getSynonyms().equals(this.getSynonyms())) {
            return false;
        }
        if (other.getStopwords() == null ^ this.getStopwords() == null) {
            return false;
        }
        if (other.getStopwords() != null && !other.getStopwords().equals(this.getStopwords())) {
            return false;
        }
        if (other.getStemmingDictionary() == null ^ this.getStemmingDictionary() == null) {
            return false;
        }
        if (other.getStemmingDictionary() != null && !other.getStemmingDictionary().equals(this.getStemmingDictionary())) {
            return false;
        }
        if (other.getAlgorithmicStemming() == null ^ this.getAlgorithmicStemming() == null) {
            return false;
        }
        return other.getAlgorithmicStemming() == null || other.getAlgorithmicStemming().equals(this.getAlgorithmicStemming());
    }
}

