/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.util;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorFactory {
    public static ExecutorService newThreadPool(int minThreads, int maxThreads, long maxIdleTime, TimeUnit unit) {
        TaskQueue taskqueue = new TaskQueue();
        ThreadPoolExecutor service = new ThreadPoolExecutor(minThreads, maxThreads, maxIdleTime, unit, taskqueue);
        taskqueue.setParent(service);
        return service;
    }

    public static ExecutorService newThreadPool(int minThreads, int maxThreads, long maxIdleTime, TimeUnit unit, ThreadFactory threadFactory) {
        TaskQueue taskqueue = new TaskQueue();
        ThreadPoolExecutor service = new ThreadPoolExecutor(minThreads, maxThreads, maxIdleTime, unit, (BlockingQueue<Runnable>)taskqueue, threadFactory);
        taskqueue.setParent(service);
        return service;
    }

    private static class TaskQueue
    extends LinkedBlockingQueue<Runnable> {
        private static final long serialVersionUID = 1L;
        ThreadPoolExecutor parent = null;

        public TaskQueue() {
        }

        public TaskQueue(int initialCapacity) {
            super(initialCapacity);
        }

        public TaskQueue(Collection<? extends Runnable> c) {
            super(c);
        }

        public void setParent(ThreadPoolExecutor tp) {
            this.parent = tp;
        }

        public boolean force(Runnable o) {
            if (this.parent.isShutdown()) {
                throw new RejectedExecutionException("Executor not running, can't force a command into the queue");
            }
            return super.offer(o);
        }

        @Override
        public boolean offer(Runnable o) {
            if (this.parent == null) {
                return super.offer(o);
            }
            if (this.parent.getPoolSize() == this.parent.getMaximumPoolSize()) {
                return super.offer(o);
            }
            if (this.parent.getActiveCount() < this.parent.getPoolSize()) {
                return super.offer(o);
            }
            if (this.parent.getPoolSize() < this.parent.getMaximumPoolSize()) {
                return false;
            }
            return super.offer(o);
        }
    }
}

