/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.BitStringSyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class NameAndOptionalUIDSyntaxChecker
extends SyntaxChecker {
    public static final NameAndOptionalUIDSyntaxChecker INSTANCE = new NameAndOptionalUIDSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.34");

    private NameAndOptionalUIDSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
            return false;
        }
        int sharpPos = strValue.lastIndexOf(35);
        if (sharpPos != -1) {
            if (strValue.indexOf(35) != sharpPos) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
                }
                return false;
            }
            if (BitStringSyntaxChecker.isValid(strValue.substring(sharpPos + 1)) && sharpPos < strValue.length()) {
                if (sharpPos > 0) {
                    boolean result = Dn.isValid(strValue.substring(0, sharpPos));
                    if (LOG.isDebugEnabled()) {
                        if (result) {
                            LOG.debug(I18n.msg(I18n.MSG_04489_SYNTAX_VALID, value));
                        } else {
                            LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
                        }
                    }
                    return result;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
            return false;
        }
        boolean result = Dn.isValid(strValue);
        if (LOG.isDebugEnabled()) {
            if (result) {
                LOG.debug(I18n.msg(I18n.MSG_04489_SYNTAX_VALID, value));
            } else {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<NameAndOptionalUIDSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.34");
        }

        @Override
        public NameAndOptionalUIDSyntaxChecker build() {
            return new NameAndOptionalUIDSyntaxChecker(this.oid);
        }
    }
}

