/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.cli.artemis.schema;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.activemq.cli.schema.ActivemqJournalType;
import org.apache.activemq.cli.schema.AddressBindingType;
import org.apache.activemq.cli.schema.MessageType;
import org.apache.activemq.cli.schema.ObjectFactory;
import org.apache.activemq.cli.schema.QueueBindingType;

public class ArtemisJournalMarshaller {
    private final ObjectFactory factory = new ObjectFactory();
    private final JAXBContext context;
    private final Marshaller marshaller;
    private final XMLStreamWriter xmlWriter;
    final JAXBElement<ActivemqJournalType> journalElement = this.factory.createActivemqJournal(new ActivemqJournalType());

    public ArtemisJournalMarshaller(XMLStreamWriter xmlWriter) throws JAXBException {
        this.context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        this.marshaller = this.context.createMarshaller();
        this.marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        PrettyPrintHandler handler = new PrettyPrintHandler(xmlWriter);
        this.xmlWriter = (XMLStreamWriter)Proxy.newProxyInstance(XMLStreamWriter.class.getClassLoader(), new Class[]{XMLStreamWriter.class}, (InvocationHandler)handler);
    }

    public void appendJournalOpen() throws XMLStreamException {
        this.xmlWriter.writeStartDocument();
        this.xmlWriter.writeStartElement(this.journalElement.getName().toString());
    }

    public void appendJournalClose(boolean closeWriter) throws XMLStreamException {
        this.xmlWriter.writeEndDocument();
        if (closeWriter) {
            this.xmlWriter.flush();
            this.xmlWriter.close();
        }
    }

    public void appendMessagesElement() throws XMLStreamException {
        this.xmlWriter.writeStartElement("messages");
    }

    public void appendBindingsElement() throws XMLStreamException {
        this.xmlWriter.writeStartElement("bindings");
    }

    public void appendEndElement() throws XMLStreamException {
        this.xmlWriter.writeEndElement();
    }

    public void appendMessage(MessageType message) throws JAXBException {
        this.marshaller.marshal(this.wrap("message", message), this.xmlWriter);
    }

    public void appendBinding(AddressBindingType addressBinding) throws JAXBException {
        this.marshaller.marshal(this.wrap("address-binding", addressBinding), this.xmlWriter);
    }

    public void appendBinding(QueueBindingType queueBinding) throws JAXBException {
        this.marshaller.marshal(this.wrap("queue-binding", queueBinding), this.xmlWriter);
    }

    private <T> JAXBElement<T> wrap(String name, T object) {
        return new JAXBElement(QName.valueOf(name), object.getClass(), object);
    }

    static class PrettyPrintHandler
    implements InvocationHandler {
        private static final Pattern XML_CHARS = Pattern.compile("[&<>]");
        private final XMLStreamWriter target;
        private int depth = 0;
        private static final char INDENT_CHAR = ' ';
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        boolean wrap = true;

        PrettyPrintHandler(XMLStreamWriter target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String m = method.getName();
            boolean useCData = false;
            switch (m) {
                case "writeStartElement": {
                    this.target.writeCharacters(LINE_SEPARATOR);
                    this.target.writeCharacters(this.indent(this.depth));
                    ++this.depth;
                    break;
                }
                case "writeEndElement": {
                    --this.depth;
                    if (this.wrap) {
                        this.target.writeCharacters(LINE_SEPARATOR);
                        this.target.writeCharacters(this.indent(this.depth));
                    }
                    this.wrap = true;
                    break;
                }
                case "writeEmptyElement": 
                case "writeCData": {
                    this.target.writeCharacters(LINE_SEPARATOR);
                    this.target.writeCharacters(this.indent(this.depth));
                    break;
                }
                case "writeCharacters": {
                    useCData = XML_CHARS.matcher((String)args[0]).find();
                    if (!useCData) {
                        this.wrap = false;
                        break;
                    }
                    this.target.writeCharacters(LINE_SEPARATOR);
                    this.target.writeCharacters(this.indent(this.depth));
                }
            }
            if (useCData) {
                Method cdata = XMLStreamWriter.class.getMethod("writeCData", String.class);
                args[0] = ((String)args[0]).replace("<![CDATA[", "").replace("]]>", "");
                cdata.invoke((Object)this.target, args);
            } else {
                method.invoke((Object)this.target, args);
            }
            return null;
        }

        private String indent(int depth) {
            char[] output = new char[depth *= 3];
            while (depth-- > 0) {
                output[depth] = 32;
            }
            return new String(output);
        }
    }
}

