/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.activemq.artemis.cli.commands.messages.perf.MessageListenerBenchmark;
import org.apache.activemq.artemis.cli.commands.messages.perf.MicrosTimeProvider;

public class MessageListenerBenchmarkBuilder {
    private ConnectionFactory factory;
    private MicrosTimeProvider timeProvider;
    private int consumers;
    private long messageCount;
    private int connections;
    private String clientID;
    private Destination[] destinations;
    private boolean transaction;
    private int sharedSubscription;
    private boolean durableSubscription;
    private boolean canDelayMessageCount;

    public MessageListenerBenchmarkBuilder setFactory(ConnectionFactory factory) {
        this.factory = factory;
        return this;
    }

    public MessageListenerBenchmarkBuilder setTimeProvider(MicrosTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return this;
    }

    public MessageListenerBenchmarkBuilder setConsumers(int consumers) {
        this.consumers = consumers;
        return this;
    }

    public MessageListenerBenchmarkBuilder setMessageCount(long messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public MessageListenerBenchmarkBuilder setConnections(int connections) {
        this.connections = connections;
        return this;
    }

    public MessageListenerBenchmarkBuilder setClientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public MessageListenerBenchmarkBuilder setDestinations(Destination[] destinations) {
        this.destinations = destinations;
        return this;
    }

    public MessageListenerBenchmarkBuilder setTransacted(boolean transacted) {
        this.transaction = transacted;
        return this;
    }

    public MessageListenerBenchmarkBuilder setSharedSubscription(int sharedSubscription) {
        this.sharedSubscription = sharedSubscription;
        return this;
    }

    public MessageListenerBenchmarkBuilder setDurableSubscription(boolean durableSubscription) {
        this.durableSubscription = durableSubscription;
        return this;
    }

    public MessageListenerBenchmarkBuilder setCanDelayMessageCount(boolean canDelayMessageCount) {
        this.canDelayMessageCount = canDelayMessageCount;
        return this;
    }

    public MessageListenerBenchmark createMessageListenerBenchmark() {
        return new MessageListenerBenchmark(this.factory, this.timeProvider, this.consumers, this.messageCount, this.connections, this.clientID, this.destinations, this.transaction, this.sharedSubscription, this.durableSubscription, this.canDelayMessageCount);
    }
}

