/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task.budget;

import java.time.Duration;
import org.apache.camel.support.task.budget.IterationBoundedBudget;
import org.apache.camel.support.task.budget.IterationBudget;
import org.apache.camel.support.task.budget.TimeBoundedBudget;
import org.apache.camel.support.task.budget.TimeBudget;

public class IterationTimeBoundedBudget
implements IterationBudget,
TimeBudget {
    private final IterationBudget iterationBudget;
    private final TimeBoundedBudget timeBoundedBudget;

    public IterationTimeBoundedBudget(long initialDelay, long interval, int maxIterations, long maxDuration) {
        this.iterationBudget = new IterationBoundedBudget(initialDelay, interval, maxIterations);
        this.timeBoundedBudget = new TimeBoundedBudget(initialDelay, interval, maxDuration);
    }

    @Override
    public long initialDelay() {
        return this.iterationBudget.initialDelay();
    }

    @Override
    public long interval() {
        return this.iterationBudget.interval();
    }

    @Override
    public int maxIterations() {
        return this.iterationBudget.maxIterations();
    }

    @Override
    public int iteration() {
        return this.iterationBudget.iteration();
    }

    @Override
    public boolean next() {
        if (this.canContinue()) {
            return this.iterationBudget.next();
        }
        return false;
    }

    @Override
    public boolean canContinue() {
        if (!this.iterationBudget.canContinue()) {
            return false;
        }
        return this.timeBoundedBudget.canContinue();
    }

    @Override
    public long maxDuration() {
        return this.timeBoundedBudget.maxDuration();
    }

    @Override
    public Duration elapsed() {
        return this.timeBoundedBudget.elapsed();
    }
}

