/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.client.PluginEnvironment;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.PluginConfig;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.client.admin.compaction.CompactionConfigurer;
import org.apache.accumulo.core.client.admin.compaction.CompactionSelector;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.clientImpl.UserCompactionUtils;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.metadata.CompactableFileImpl;
import org.apache.accumulo.core.metadata.ReferencedTabletFile;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.spi.compaction.CompactionJob;
import org.apache.accumulo.core.spi.compaction.CompactionKind;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.summary.Gatherer;
import org.apache.accumulo.core.summary.SummarizerFactory;
import org.apache.accumulo.core.summary.SummaryCollection;
import org.apache.accumulo.core.summary.SummaryReader;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServiceEnvironmentImpl;
import org.apache.accumulo.server.compaction.CompactionStats;
import org.apache.accumulo.server.compaction.FileCompactor;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.tablet.CompactableImpl;
import org.apache.accumulo.tserver.tablet.DatafileManager;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;

public class CompactableUtils {
    public static Map<StoredTabletFile, Pair<Key, Key>> getFirstAndLastKeys(Tablet tablet, Set<StoredTabletFile> allFiles) throws IOException {
        HashMap<StoredTabletFile, Pair<Key, Key>> result = new HashMap<StoredTabletFile, Pair<Key, Key>>();
        FileOperations fileFactory = FileOperations.getInstance();
        VolumeManager fs = tablet.getTabletServer().getVolumeManager();
        TableConfiguration tableConf = tablet.getTableConfiguration();
        CryptoService cs = tableConf.getCryptoService();
        for (StoredTabletFile file : allFiles) {
            FileSystem ns = fs.getFileSystemByPath(file.getPath());
            FileSKVIterator openReader = fileFactory.newReaderBuilder().forFile((TabletFile)file, ns, ns.getConf(), cs).withTableConfiguration((AccumuloConfiguration)tableConf).seekToBeginning().build();
            try {
                Key first = openReader.getFirstKey();
                Key last = openReader.getLastKey();
                result.put(file, (Pair<Key, Key>)new Pair((Object)first, (Object)last));
            }
            finally {
                if (openReader == null) continue;
                openReader.close();
            }
        }
        return result;
    }

    public static Set<StoredTabletFile> findChopFiles(KeyExtent extent, Map<StoredTabletFile, Pair<Key, Key>> firstAndLastKeys, Collection<StoredTabletFile> allFiles) {
        HashSet<StoredTabletFile> result = new HashSet<StoredTabletFile>();
        for (StoredTabletFile file : allFiles) {
            Pair<Key, Key> pair = firstAndLastKeys.get(file);
            Key first = (Key)pair.getFirst();
            Key last = (Key)pair.getSecond();
            if (!(first == null && last == null || first != null && !extent.contains((BinaryComparable)first.getRow())) && (last == null || extent.contains((BinaryComparable)last.getRow()))) continue;
            result.add(file);
        }
        return result;
    }

    static Map<String, String> computeOverrides(Tablet tablet, Set<CompactableFile> files) {
        TableConfiguration tconf = tablet.getTableConfiguration();
        String configurorClass = tconf.get(Property.TABLE_COMPACTION_CONFIGURER);
        if (configurorClass == null || configurorClass.isBlank()) {
            return null;
        }
        Map opts = tconf.getAllPropertiesWithPrefixStripped(Property.TABLE_COMPACTION_CONFIGURER_OPTS);
        return CompactableUtils.computeOverrides(tablet, files, new PluginConfig(configurorClass, opts));
    }

    static Map<String, String> computeOverrides(Tablet tablet, final Set<CompactableFile> files, final PluginConfig cfg) {
        CompactionConfigurer configurer = CompactableUtils.newInstance((AccumuloConfiguration)tablet.getTableConfiguration(), cfg.getClassName(), CompactionConfigurer.class);
        ServiceEnvironmentImpl senv = new ServiceEnvironmentImpl(tablet.getContext());
        configurer.init(new CompactionConfigurer.InitParameters((ServiceEnvironment)senv, tablet){
            final /* synthetic */ ServiceEnvironment val$senv;
            final /* synthetic */ Tablet val$tablet;
            {
                this.val$senv = serviceEnvironment;
                this.val$tablet = tablet;
            }

            public Map<String, String> getOptions() {
                return cfg.getOptions();
            }

            public PluginEnvironment getEnvironment() {
                return this.val$senv;
            }

            public TableId getTableId() {
                return this.val$tablet.getExtent().tableId();
            }
        });
        CompactionConfigurer.Overrides overrides = configurer.override(new CompactionConfigurer.InputParameters((ServiceEnvironment)senv, tablet){
            final /* synthetic */ ServiceEnvironment val$senv;
            final /* synthetic */ Tablet val$tablet;
            {
                this.val$senv = serviceEnvironment;
                this.val$tablet = tablet;
            }

            public Collection<CompactableFile> getInputFiles() {
                return files;
            }

            public PluginEnvironment getEnvironment() {
                return this.val$senv;
            }

            public TableId getTableId() {
                return this.val$tablet.getExtent().tableId();
            }

            public TabletId getTabletId() {
                return new TabletIdImpl(this.val$tablet.getExtent());
            }
        });
        if (overrides.getOverrides().isEmpty()) {
            return null;
        }
        return overrides.getOverrides();
    }

    static <T> T newInstance(AccumuloConfiguration tableConfig, String className, Class<T> baseClass) {
        String context = ClassLoaderUtil.tableContext((AccumuloConfiguration)tableConfig);
        try {
            return (T)ConfigurationTypeHelper.getClassInstance((String)context, (String)className, baseClass);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static Set<StoredTabletFile> selectFiles(Tablet tablet, SortedMap<StoredTabletFile, DataFileValue> datafiles, final PluginConfig selectorConfig) {
        CompactionSelector selector = CompactableUtils.newInstance((AccumuloConfiguration)tablet.getTableConfiguration(), selectorConfig.getClassName(), CompactionSelector.class);
        ServiceEnvironmentImpl senv = new ServiceEnvironmentImpl(tablet.getContext());
        selector.init(new CompactionSelector.InitParameters((ServiceEnvironment)senv, tablet){
            final /* synthetic */ ServiceEnvironment val$senv;
            final /* synthetic */ Tablet val$tablet;
            {
                this.val$senv = serviceEnvironment;
                this.val$tablet = tablet;
            }

            public Map<String, String> getOptions() {
                return selectorConfig.getOptions();
            }

            public PluginEnvironment getEnvironment() {
                return this.val$senv;
            }

            public TableId getTableId() {
                return this.val$tablet.getExtent().tableId();
            }
        });
        CompactionSelector.Selection selection = selector.select(new CompactionSelector.SelectionParameters((ServiceEnvironment)senv, datafiles, tablet){
            final /* synthetic */ ServiceEnvironment val$senv;
            final /* synthetic */ SortedMap val$datafiles;
            final /* synthetic */ Tablet val$tablet;
            {
                this.val$senv = serviceEnvironment;
                this.val$datafiles = sortedMap;
                this.val$tablet = tablet;
            }

            public PluginEnvironment getEnvironment() {
                return this.val$senv;
            }

            public Collection<CompactableFile> getAvailableFiles() {
                return Collections2.transform(this.val$datafiles.entrySet(), e -> new CompactableFileImpl((StoredTabletFile)e.getKey(), (DataFileValue)e.getValue()));
            }

            public Collection<Summary> getSummaries(Collection<CompactableFile> files, Predicate<SummarizerConfiguration> summarySelector) {
                ServerContext context = this.val$tablet.getContext();
                TabletServerResourceManager tsrm = this.val$tablet.getTabletResources().getTabletServerResourceManager();
                TableConfiguration tableConf = this.val$tablet.getTableConfiguration();
                SummaryCollection sc = new SummaryCollection();
                SummarizerFactory factory = new SummarizerFactory((AccumuloConfiguration)tableConf);
                for (CompactableFile cf : files) {
                    StoredTabletFile file = CompactableFileImpl.toStoredTabletFile((CompactableFile)cf);
                    FileSystem fs = context.getVolumeManager().getFileSystemByPath(file.getPath());
                    Configuration conf = context.getHadoopConf();
                    SummaryCollection fsc = SummaryReader.load((FileSystem)fs, (Configuration)conf, (SummarizerFactory)factory, (Path)file.getPath(), summarySelector, (BlockCache)tsrm.getSummaryCache(), (BlockCache)tsrm.getIndexCache(), tsrm.getFileLenCache(), (CryptoService)tableConf.getCryptoService()).getSummaries(Collections.singletonList(new Gatherer.RowRange(this.val$tablet.getExtent())));
                    sc.merge(fsc, factory);
                }
                return sc.getSummaries();
            }

            public TableId getTableId() {
                return this.val$tablet.getExtent().tableId();
            }

            public TabletId getTabletId() {
                return new TabletIdImpl(this.val$tablet.getExtent());
            }

            public Optional<SortedKeyValueIterator<Key, Value>> getSample(CompactableFile file, SamplerConfiguration sc) {
                try {
                    FileOperations fileFactory = FileOperations.getInstance();
                    Path path = new Path(file.getUri());
                    FileSystem ns = this.val$tablet.getTabletServer().getVolumeManager().getFileSystemByPath(path);
                    TableConfiguration tableConf = this.val$tablet.getTableConfiguration();
                    FileSKVIterator fiter = fileFactory.newReaderBuilder().forFile((TabletFile)ReferencedTabletFile.of((Path)path), ns, ns.getConf(), tableConf.getCryptoService()).withTableConfiguration((AccumuloConfiguration)tableConf).seekToBeginning().build();
                    return Optional.ofNullable(fiter.getSample(new SamplerConfigurationImpl(sc)));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        return selection.getFilesToCompact().stream().map(CompactableFileImpl::toStoredTabletFile).collect(Collectors.toSet());
    }

    public static CompactableImpl.CompactionHelper getHelper(CompactionKind kind, Tablet tablet, Long compactionId, CompactionConfig compactionConfig) {
        if (kind == CompactionKind.USER) {
            return new UserCompactionHelper(compactionConfig, tablet, compactionId);
        }
        if (kind == CompactionKind.SELECTOR) {
            TableConfiguration tconf = tablet.getTableConfiguration();
            String selectorClassName = tconf.get(Property.TABLE_COMPACTION_SELECTOR);
            PluginConfig cselCfg = null;
            if (selectorClassName != null && !selectorClassName.isBlank()) {
                Map opts = tconf.getAllPropertiesWithPrefixStripped(Property.TABLE_COMPACTION_SELECTOR_OPTS);
                cselCfg = new PluginConfig(selectorClassName, opts);
            }
            if (cselCfg != null) {
                return new TableCompactionHelper(cselCfg, tablet);
            }
        }
        return null;
    }

    public static Map<String, String> getOverrides(CompactionKind kind, Tablet tablet, CompactableImpl.CompactionHelper driver, Set<CompactableFile> files) {
        Map<String, String> overrides = null;
        if (kind == CompactionKind.USER || kind == CompactionKind.SELECTOR) {
            overrides = driver.getConfigOverrides(files);
        }
        if (overrides == null) {
            overrides = CompactableUtils.computeOverrides(tablet, files);
        }
        if (overrides == null) {
            return Map.of();
        }
        return overrides;
    }

    private static AccumuloConfiguration getCompactionConfig(TableConfiguration tableConfiguration, Map<String, String> overrides) {
        if (overrides.isEmpty()) {
            return tableConfiguration;
        }
        ConfigurationCopy copy = new ConfigurationCopy((Iterable)tableConfiguration);
        overrides.forEach((k, v) -> copy.set(k, v));
        return copy;
    }

    static CompactionStats compact(Tablet tablet, CompactionJob job, CompactableImpl.CompactionInfo cInfo, FileCompactor.CompactionEnv cenv, Map<StoredTabletFile, DataFileValue> compactFiles, ReferencedTabletFile tmpFileName) throws IOException, FileCompactor.CompactionCanceledException {
        TableConfiguration tableConf = tablet.getTableConfiguration();
        AccumuloConfiguration compactionConfig = CompactableUtils.getCompactionConfig(tableConf, CompactableUtils.getOverrides(job.getKind(), tablet, cInfo.localHelper, job.getFiles()));
        FileCompactor compactor = new FileCompactor(tablet.getContext(), tablet.getExtent(), compactFiles, tmpFileName, cInfo.propagateDeletes, cenv, cInfo.iters, compactionConfig, tableConf.getCryptoService(), tablet.getPausedCompactionMetrics());
        return compactor.call();
    }

    static Optional<StoredTabletFile> bringOnline(DatafileManager datafileManager, CompactableImpl.CompactionInfo cInfo, CompactionStats stats, Map<StoredTabletFile, DataFileValue> compactFiles, ReferencedTabletFile compactTmpName) throws IOException {
        DataFileValue dfv = new DataFileValue(stats.getFileSize(), stats.getEntriesWritten());
        return datafileManager.bringMajorCompactionOnline(compactFiles.keySet(), compactTmpName, cInfo.checkCompactionId, cInfo.selectedFiles, dfv, Optional.empty());
    }

    public static ReferencedTabletFile computeCompactionFileDest(ReferencedTabletFile tmpFile) {
        String newFilePath = tmpFile.getMetaInsert();
        int idx = newFilePath.indexOf("_tmp");
        if (idx <= 0) {
            throw new IllegalArgumentException("Expected compaction tmp file " + tmpFile.getMetaInsert() + " to have suffix '_tmp'");
        }
        newFilePath = newFilePath.substring(0, idx);
        return new ReferencedTabletFile(new Path(newFilePath));
    }

    private static final class UserCompactionHelper
    implements CompactableImpl.CompactionHelper {
        private final CompactionConfig compactionConfig;
        private final Tablet tablet;
        private final Long compactionId;

        private UserCompactionHelper(CompactionConfig compactionConfig, Tablet tablet, Long compactionId) {
            this.compactionConfig = compactionConfig;
            this.tablet = tablet;
            this.compactionId = compactionId;
        }

        @Override
        public Set<StoredTabletFile> selectFiles(SortedMap<StoredTabletFile, DataFileValue> allFiles) {
            Set<StoredTabletFile> selectedFiles = !UserCompactionUtils.isDefault((PluginConfig)this.compactionConfig.getSelector()) ? CompactableUtils.selectFiles(this.tablet, allFiles, this.compactionConfig.getSelector()) : allFiles.keySet();
            if (selectedFiles.isEmpty()) {
                MetadataTableUtil.updateTabletCompactID((KeyExtent)this.tablet.getExtent(), (long)this.compactionId, (ServerContext)this.tablet.getTabletServer().getContext(), (ServiceLock)this.tablet.getTabletServer().getLock());
                this.tablet.setLastCompactionID(this.compactionId);
            }
            return selectedFiles;
        }

        @Override
        public Map<String, String> getConfigOverrides(Set<CompactableFile> files) {
            if (!UserCompactionUtils.isDefault((PluginConfig)this.compactionConfig.getConfigurer())) {
                return CompactableUtils.computeOverrides(this.tablet, files, this.compactionConfig.getConfigurer());
            }
            return null;
        }
    }

    private static final class TableCompactionHelper
    implements CompactableImpl.CompactionHelper {
        private final PluginConfig cselCfg2;
        private final Tablet tablet;

        private TableCompactionHelper(PluginConfig cselCfg2, Tablet tablet) {
            this.cselCfg2 = Objects.requireNonNull(cselCfg2);
            this.tablet = Objects.requireNonNull(tablet);
        }

        @Override
        public Set<StoredTabletFile> selectFiles(SortedMap<StoredTabletFile, DataFileValue> allFiles) {
            return CompactableUtils.selectFiles(this.tablet, allFiles, this.cselCfg2);
        }

        @Override
        public Map<String, String> getConfigOverrides(Set<CompactableFile> files) {
            return null;
        }
    }
}

