/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.sample.Sampler;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.rfile.RFileOperations;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.iteratorsImpl.system.EmptyIterator;
import org.apache.accumulo.core.iteratorsImpl.system.InterruptibleIterator;
import org.apache.accumulo.core.iteratorsImpl.system.LocalityGroupIterator;
import org.apache.accumulo.core.iteratorsImpl.system.SortedMapIterator;
import org.apache.accumulo.core.iteratorsImpl.system.SourceSwitchingIterator;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.UnreferencedTabletFile;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.sample.impl.SamplerFactory;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.PreAllocatedArray;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.tserver.MemKey;
import org.apache.accumulo.tserver.MemKeyComparator;
import org.apache.accumulo.tserver.MemKeyConversionIterator;
import org.apache.accumulo.tserver.MemValue;
import org.apache.accumulo.tserver.NativeMap;
import org.apache.accumulo.tserver.PartialMutationSkippingIterator;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMap {
    private SimpleMap map = null;
    private static final Logger log = LoggerFactory.getLogger(InMemoryMap.class);
    private final ServerContext context;
    private volatile String memDumpFile = null;
    private final String memDumpDir;
    private final String mapType;
    private final TableId tableId;
    private Map<String, Set<ByteSequence>> lggroups;
    public static final String TYPE_NATIVE_MAP_WRAPPER = "NativeMapWrapper";
    public static final String TYPE_DEFAULT_MAP = "DefaultMap";
    public static final String TYPE_LOCALITY_GROUP_MAP = "LocalityGroupMap";
    public static final String TYPE_LOCALITY_GROUP_MAP_NATIVE = "LocalityGroupMap with native";
    private AtomicReference<Pair<SamplerConfigurationImpl, Sampler>> samplerRef = new AtomicReference<Object>(null);
    private AccumuloConfiguration config;
    private AtomicInteger nextKVCount = new AtomicInteger(1);
    private AtomicInteger kvCount = new AtomicInteger(0);
    private Object writeSerializer = new Object();
    private final Set<MemoryIterator> activeIters = Collections.synchronizedSet(new HashSet());
    private boolean deleted = false;

    private static Pair<SamplerConfigurationImpl, Sampler> getSampler(AccumuloConfiguration config) {
        try {
            SamplerConfigurationImpl sampleConfig = SamplerConfigurationImpl.newSamplerConfig((AccumuloConfiguration)config);
            if (sampleConfig == null) {
                return new Pair(null, null);
            }
            return new Pair((Object)sampleConfig, (Object)SamplerFactory.newSampler((SamplerConfigurationImpl)sampleConfig, (AccumuloConfiguration)config));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Sampler getOrCreateSampler() {
        Pair<SamplerConfigurationImpl, Sampler> pair = this.samplerRef.get();
        if (pair == null && !this.samplerRef.compareAndSet(null, pair = InMemoryMap.getSampler(this.config))) {
            pair = this.samplerRef.get();
        }
        return (Sampler)pair.getSecond();
    }

    public InMemoryMap(AccumuloConfiguration config, ServerContext context, TableId tableId) {
        SimpleMap sampleMap;
        SimpleMap allMap;
        boolean useNativeMap = config.getBoolean(Property.TSERV_NATIVEMAP_ENABLED);
        this.memDumpDir = config.get(Property.TSERV_MEMDUMP_DIR);
        this.lggroups = LocalityGroupUtil.getLocalityGroupsIgnoringErrors((AccumuloConfiguration)config, (TableId)tableId);
        this.config = config;
        this.context = context;
        this.tableId = tableId;
        if (this.lggroups.isEmpty()) {
            allMap = InMemoryMap.newMap(useNativeMap);
            sampleMap = InMemoryMap.newMap(useNativeMap);
            this.mapType = useNativeMap ? TYPE_NATIVE_MAP_WRAPPER : TYPE_DEFAULT_MAP;
        } else {
            allMap = new LocalityGroupMap(this.lggroups, useNativeMap);
            sampleMap = new LocalityGroupMap(this.lggroups, useNativeMap);
            this.mapType = useNativeMap ? TYPE_LOCALITY_GROUP_MAP_NATIVE : TYPE_LOCALITY_GROUP_MAP;
        }
        this.map = new SampleMap(allMap, sampleMap);
    }

    private static SimpleMap newMap(boolean useNativeMap) {
        if (useNativeMap) {
            try {
                return new NativeMapWrapper();
            }
            catch (Exception t) {
                log.error("Failed to create native map", (Throwable)t);
            }
        }
        return new DefaultMap();
    }

    public String getMapType() {
        return this.mapType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(List<Mutation> mutations, int numKVs) {
        Object object = this.writeSerializer;
        synchronized (object) {
            int kv = this.nextKVCount.getAndAdd(numKVs);
            try {
                this.map.mutate(mutations, kv);
            }
            finally {
                this.kvCount.set(kv + numKVs - 1);
            }
        }
    }

    public synchronized long estimatedSizeInBytes() {
        if (this.map == null) {
            return 0L;
        }
        return this.map.getMemoryUsed();
    }

    public synchronized long getNumEntries() {
        if (this.map == null) {
            return 0L;
        }
        return this.map.size();
    }

    public synchronized MemoryIterator skvIterator(SamplerConfigurationImpl iteratorSamplerConfig) {
        if (this.map == null) {
            throw new NullPointerException();
        }
        if (this.deleted) {
            throw new IllegalStateException("Can not obtain iterator after map deleted");
        }
        int mc = this.kvCount.get();
        MemoryDataSource mds = new MemoryDataSource(iteratorSamplerConfig);
        SourceSwitchingIterator ssi = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)mds);
        MemoryIterator mi = new MemoryIterator(new PartialMutationSkippingIterator((SortedKeyValueIterator<Key, Value>)ssi, mc));
        mi.setSSI(ssi);
        mi.setMDS(mds);
        this.activeIters.add(mi);
        return mi;
    }

    public SortedKeyValueIterator<Key, Value> compactionIterator() {
        if (this.nextKVCount.get() - 1 != this.kvCount.get()) {
            throw new IllegalStateException("Memory map in unexpected state : nextKVCount = " + this.nextKVCount.get() + " kvCount = " + this.kvCount.get());
        }
        return this.map.skvIterator(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(long waitTime) {
        InMemoryMap inMemoryMap = this;
        synchronized (inMemoryMap) {
            if (this.deleted) {
                throw new IllegalStateException("Double delete");
            }
            this.deleted = true;
        }
        long t1 = System.currentTimeMillis();
        while (!this.activeIters.isEmpty() && System.currentTimeMillis() - t1 < waitTime) {
            Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        if (!this.activeIters.isEmpty()) {
            try {
                Configuration conf = this.context.getHadoopConf();
                LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
                String tmpFile = this.memDumpDir + "/memDump" + UUID.randomUUID() + ".rf";
                Configuration newConf = new Configuration(conf);
                newConf.setInt("io.seqfile.compress.blocksize", 100000);
                AccumuloConfiguration aconf = this.context.getConfiguration();
                if (this.getOrCreateSampler() != null) {
                    aconf = this.createSampleConfig(aconf);
                }
                TableConfiguration tableConf = this.context.getTableConfiguration(this.tableId);
                FileSKVWriter out = new RFileOperations().newWriterBuilder().forFile((TabletFile)UnreferencedTabletFile.of((FileSystem)fs, (Path)new Path(tmpFile)), (FileSystem)fs, newConf, tableConf.getCryptoService()).withTableConfiguration(aconf).build();
                InterruptibleIterator iter = this.map.skvIterator(null);
                HashSet allfams = new HashSet();
                for (Map.Entry<String, Set<ByteSequence>> entry : this.lggroups.entrySet()) {
                    allfams.addAll(entry.getValue());
                    out.startNewLocalityGroup(entry.getKey(), entry.getValue());
                    iter.seek(new Range(), (Collection)entry.getValue(), true);
                    this.dumpLocalityGroup(out, iter);
                }
                out.startDefaultLocalityGroup();
                iter.seek(new Range(), allfams, false);
                this.dumpLocalityGroup(out, iter);
                out.close();
                log.debug("Created mem dump file {}", (Object)tmpFile);
                this.memDumpFile = tmpFile;
                Set<MemoryIterator> set = this.activeIters;
                synchronized (set) {
                    for (MemoryIterator mi : this.activeIters) {
                        mi.switchNow();
                    }
                }
                fs.delete(new Path(this.memDumpFile), true);
            }
            catch (IOException ioe) {
                log.error("Failed to create mem dump file", (Throwable)ioe);
                while (!this.activeIters.isEmpty()) {
                    Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }
        }
        SimpleMap tmpMap = this.map;
        InMemoryMap inMemoryMap2 = this;
        synchronized (inMemoryMap2) {
            this.map = null;
        }
        tmpMap.delete();
    }

    private AccumuloConfiguration createSampleConfig(AccumuloConfiguration siteConf) {
        ConfigurationCopy confCopy = new ConfigurationCopy(siteConf.stream().filter(input -> !((String)input.getKey()).startsWith(Property.TABLE_SAMPLER.getKey())));
        for (Map.Entry entry : ((SamplerConfigurationImpl)this.samplerRef.get().getFirst()).toTablePropertiesMap().entrySet()) {
            confCopy.set((String)entry.getKey(), (String)entry.getValue());
        }
        siteConf = confCopy;
        return siteConf;
    }

    private void dumpLocalityGroup(FileSKVWriter out, InterruptibleIterator iter) throws IOException {
        while (iter.hasTop() && !this.activeIters.isEmpty()) {
            out.append((Key)iter.getTopKey(), MemValue.encode((Value)iter.getTopValue(), ((MemKey)iter.getTopKey()).getKVCount()));
            iter.next();
        }
    }

    public class MemoryIterator
    extends WrappingIterator
    implements InterruptibleIterator {
        private AtomicBoolean closed;
        private SourceSwitchingIterator ssi;
        private MemoryDataSource mds;

        private MemoryIterator(InterruptibleIterator source) {
            this((SortedKeyValueIterator<Key, Value>)source, new AtomicBoolean(false));
        }

        private MemoryIterator(SortedKeyValueIterator<Key, Value> source, AtomicBoolean closed) {
            this.setSource(source);
            this.closed = closed;
        }

        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            return new MemoryIterator((SortedKeyValueIterator<Key, Value>)this.getSource().deepCopy(env), this.closed);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            MemoryIterator memoryIterator = this;
            synchronized (memoryIterator) {
                if (this.closed.compareAndSet(false, true)) {
                    try {
                        if (this.mds.reader != null) {
                            this.mds.reader.close();
                        }
                    }
                    catch (IOException e) {
                        log.warn("{}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
            InMemoryMap.this.activeIters.remove((Object)this);
        }

        private synchronized boolean switchNow() throws IOException {
            if (this.closed.get()) {
                return false;
            }
            this.ssi.switchNow();
            return true;
        }

        public void setInterruptFlag(AtomicBoolean flag) {
            ((InterruptibleIterator)this.getSource()).setInterruptFlag(flag);
        }

        private void setSSI(SourceSwitchingIterator ssi) {
            this.ssi = ssi;
        }

        public void setMDS(MemoryDataSource mds) {
            this.mds = mds;
        }
    }

    class MemoryDataSource
    implements SourceSwitchingIterator.DataSource {
        private boolean switched = false;
        private InterruptibleIterator iter;
        private FileSKVIterator reader;
        private MemoryDataSource parent;
        private IteratorEnvironment env;
        private AtomicBoolean iflag;
        private SamplerConfigurationImpl iteratorSamplerConfig;

        private SamplerConfigurationImpl getSamplerConfig() {
            if (this.env != null) {
                if (this.env.isSamplingEnabled()) {
                    return new SamplerConfigurationImpl(this.env.getSamplerConfiguration());
                }
                return null;
            }
            return this.iteratorSamplerConfig;
        }

        MemoryDataSource(SamplerConfigurationImpl samplerConfig) {
            this(null, false, null, null, samplerConfig);
        }

        public MemoryDataSource(MemoryDataSource parent, boolean switched, IteratorEnvironment env, AtomicBoolean iflag, SamplerConfigurationImpl samplerConfig) {
            this.parent = parent;
            this.switched = switched;
            this.env = env;
            this.iflag = iflag;
            this.iteratorSamplerConfig = samplerConfig;
        }

        public boolean isCurrent() {
            if (this.switched) {
                return true;
            }
            return InMemoryMap.this.memDumpFile == null;
        }

        public SourceSwitchingIterator.DataSource getNewDataSource() {
            if (this.switched) {
                throw new IllegalStateException();
            }
            if (!this.isCurrent()) {
                this.switched = true;
                this.iter = null;
                try {
                    this.iterator();
                }
                catch (IOException e) {
                    throw new RuntimeException();
                }
            }
            return this;
        }

        private synchronized FileSKVIterator getReader() throws IOException {
            if (this.reader == null) {
                Configuration conf = InMemoryMap.this.context.getHadoopConf();
                LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
                TableConfiguration tableConf = InMemoryMap.this.context.getTableConfiguration(InMemoryMap.this.tableId);
                this.reader = new RFileOperations().newReaderBuilder().forFile((TabletFile)UnreferencedTabletFile.of((FileSystem)fs, (Path)new Path(InMemoryMap.this.memDumpFile)), (FileSystem)fs, conf, tableConf.getCryptoService()).withTableConfiguration((AccumuloConfiguration)tableConf).seekToBeginning().build();
                if (this.iflag != null) {
                    this.reader.setInterruptFlag(this.iflag);
                }
                if (this.getSamplerConfig() != null) {
                    this.reader = this.reader.getSample(this.getSamplerConfig());
                }
            }
            return this.reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedKeyValueIterator<Key, Value> iterator() throws IOException {
            if (this.iter == null) {
                if (!this.switched) {
                    this.iter = InMemoryMap.this.map.skvIterator(this.getSamplerConfig());
                    if (this.iflag != null) {
                        this.iter.setInterruptFlag(this.iflag);
                    }
                } else if (this.parent == null) {
                    this.iter = new MemKeyConversionIterator((SortedKeyValueIterator<Key, Value>)this.getReader());
                } else {
                    MemoryDataSource memoryDataSource = this.parent;
                    synchronized (memoryDataSource) {
                        this.iter = new MemKeyConversionIterator((SortedKeyValueIterator<Key, Value>)this.parent.getReader().deepCopy(this.env));
                    }
                }
            }
            return this.iter;
        }

        public SourceSwitchingIterator.DataSource getDeepCopyDataSource(IteratorEnvironment env) {
            return new MemoryDataSource(this.parent == null ? this : this.parent, this.switched, env, this.iflag, this.iteratorSamplerConfig);
        }

        public void setInterruptFlag(AtomicBoolean flag) {
            this.iflag = flag;
        }
    }

    private static class NativeMapWrapper
    implements SimpleMap {
        private NativeMap nativeMap = new NativeMap();

        NativeMapWrapper() {
        }

        @Override
        public int size() {
            return this.nativeMap.size();
        }

        @Override
        public InterruptibleIterator skvIterator(SamplerConfigurationImpl samplerConfig) {
            if (samplerConfig != null) {
                throw new SampleNotPresentException();
            }
            return (InterruptibleIterator)this.nativeMap.skvIterator();
        }

        @Override
        public void delete() {
            this.nativeMap.delete();
        }

        @Override
        public long getMemoryUsed() {
            return this.nativeMap.getMemoryUsed();
        }

        @Override
        public void mutate(List<Mutation> mutations, int kvCount) {
            this.nativeMap.mutate(mutations, kvCount);
        }
    }

    private static class DefaultMap
    implements SimpleMap {
        private ConcurrentSkipListMap<Key, Value> map = new ConcurrentSkipListMap(new MemKeyComparator());
        private AtomicLong bytesInMemory = new AtomicLong();
        private AtomicInteger size = new AtomicInteger();

        private DefaultMap() {
        }

        public void put(Key key, Value value) {
            this.bytesInMemory.addAndGet(key.getLength() + 4);
            this.bytesInMemory.addAndGet(value.getSize());
            if (this.map.put(key, value) == null) {
                this.size.incrementAndGet();
            }
        }

        @Override
        public int size() {
            return this.size.get();
        }

        @Override
        public InterruptibleIterator skvIterator(SamplerConfigurationImpl samplerConfig) {
            if (samplerConfig != null) {
                throw new SampleNotPresentException();
            }
            if (this.map == null) {
                throw new IllegalStateException();
            }
            return new SortedMapIterator(this.map);
        }

        @Override
        public synchronized void delete() {
            this.map = null;
        }

        public long getOverheadPerEntry() {
            return 200L;
        }

        @Override
        public void mutate(List<Mutation> mutations, int kvCount) {
            for (Mutation m : mutations) {
                for (ColumnUpdate cvp : m.getUpdates()) {
                    MemKey newKey = new MemKey(m.getRow(), cvp.getColumnFamily(), cvp.getColumnQualifier(), cvp.getColumnVisibility(), cvp.getTimestamp(), cvp.isDeleted(), false, kvCount++);
                    Value value = new Value(cvp.getValue());
                    this.put(newKey, value);
                }
            }
        }

        @Override
        public long getMemoryUsed() {
            return this.bytesInMemory.get() + (long)this.size() * this.getOverheadPerEntry();
        }
    }

    private static class LocalityGroupMap
    implements SimpleMap {
        private PreAllocatedArray<Map<ByteSequence, MutableLong>> groupFams;
        private SimpleMap[] maps;
        private LocalityGroupUtil.Partitioner partitioner;
        private PreAllocatedArray<List<Mutation>> partitioned;

        LocalityGroupMap(Map<String, Set<ByteSequence>> groups, boolean useNativeMap) {
            this.groupFams = new PreAllocatedArray(groups.size());
            this.maps = new SimpleMap[groups.size() + 1];
            this.partitioned = new PreAllocatedArray(groups.size() + 1);
            for (int i = 0; i < this.maps.length; ++i) {
                this.maps[i] = InMemoryMap.newMap(useNativeMap);
            }
            int count = 0;
            for (Set<ByteSequence> cfset : groups.values()) {
                HashMap<ByteSequence, MutableLong> map = new HashMap<ByteSequence, MutableLong>();
                for (ByteSequence bs : cfset) {
                    map.put(bs, new MutableLong(1L));
                }
                this.groupFams.set(count++, map);
            }
            this.partitioner = new LocalityGroupUtil.Partitioner(this.groupFams);
            for (int i = 0; i < this.partitioned.length; ++i) {
                this.partitioned.set(i, new ArrayList());
            }
        }

        @Override
        public int size() {
            int sum = 0;
            for (SimpleMap map : this.maps) {
                sum += map.size();
            }
            return sum;
        }

        @Override
        public InterruptibleIterator skvIterator(SamplerConfigurationImpl samplerConfig) {
            if (samplerConfig != null) {
                throw new SampleNotPresentException();
            }
            LocalityGroupIterator.LocalityGroup[] groups = new LocalityGroupIterator.LocalityGroup[this.maps.length];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = i < this.groupFams.length ? new LocalityGroupIterator.LocalityGroup(this.maps[i].skvIterator(null), (Map)this.groupFams.get(i), false) : new LocalityGroupIterator.LocalityGroup(this.maps[i].skvIterator(null), null, true);
            }
            return new LocalityGroupIterator(groups);
        }

        @Override
        public void delete() {
            for (SimpleMap map : this.maps) {
                map.delete();
            }
        }

        @Override
        public long getMemoryUsed() {
            long sum = 0L;
            for (SimpleMap map : this.maps) {
                sum += map.getMemoryUsed();
            }
            return sum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void mutate(List<Mutation> mutations, int kvCount) {
            try {
                this.partitioner.partition(mutations, this.partitioned);
                for (int i = 0; i < this.partitioned.length; ++i) {
                    if (((List)this.partitioned.get(i)).isEmpty()) continue;
                    this.maps[i].mutate((List)this.partitioned.get(i), kvCount);
                    for (Mutation m : (List)this.partitioned.get(i)) {
                        kvCount += m.getUpdates().size();
                    }
                }
            }
            finally {
                for (List list : this.partitioned) {
                    list.clear();
                }
            }
        }
    }

    private class SampleMap
    implements SimpleMap {
        private SimpleMap map;
        private SimpleMap sample;

        public SampleMap(SimpleMap map, SimpleMap sampleMap) {
            this.map = map;
            this.sample = sampleMap;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public InterruptibleIterator skvIterator(SamplerConfigurationImpl samplerConfig) {
            if (samplerConfig == null) {
                return this.map.skvIterator(null);
            }
            Pair<SamplerConfigurationImpl, Sampler> samplerAndConf = InMemoryMap.this.samplerRef.get();
            if (samplerAndConf == null) {
                return EmptyIterator.EMPTY_ITERATOR;
            }
            if (samplerAndConf.getFirst() != null && ((SamplerConfigurationImpl)samplerAndConf.getFirst()).equals((Object)samplerConfig)) {
                return this.sample.skvIterator(null);
            }
            throw new SampleNotPresentException();
        }

        @Override
        public void delete() {
            this.map.delete();
            this.sample.delete();
        }

        @Override
        public long getMemoryUsed() {
            return this.map.getMemoryUsed() + this.sample.getMemoryUsed();
        }

        @Override
        public void mutate(List<Mutation> mutations, int kvCount) {
            this.map.mutate(mutations, kvCount);
            Sampler sampler = InMemoryMap.this.getOrCreateSampler();
            if (sampler != null) {
                ArrayList<LocalityGroupUtil.PartitionedMutation> sampleMutations = null;
                for (Mutation m : mutations) {
                    List colUpdates = m.getUpdates();
                    ArrayList<ColumnUpdate> sampleColUpdates = null;
                    for (ColumnUpdate cvp : colUpdates) {
                        Key k = new Key(m.getRow(), cvp.getColumnFamily(), cvp.getColumnQualifier(), cvp.getColumnVisibility(), cvp.getTimestamp(), cvp.isDeleted(), false);
                        if (!sampler.accept(k)) continue;
                        if (sampleColUpdates == null) {
                            sampleColUpdates = new ArrayList<ColumnUpdate>();
                        }
                        sampleColUpdates.add(cvp);
                    }
                    if (sampleColUpdates == null) continue;
                    if (sampleMutations == null) {
                        sampleMutations = new ArrayList<LocalityGroupUtil.PartitionedMutation>();
                    }
                    sampleMutations.add(new LocalityGroupUtil.PartitionedMutation(m.getRow(), sampleColUpdates));
                }
                if (sampleMutations != null) {
                    this.sample.mutate(sampleMutations, kvCount);
                }
            }
        }
    }

    private static interface SimpleMap {
        public int size();

        public InterruptibleIterator skvIterator(SamplerConfigurationImpl var1);

        public void delete();

        public long getMemoryUsed();

        public void mutate(List<Mutation> var1, int var2);
    }
}

