/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkFailedCopyProcessor
implements DistributedWorkQueue.Processor {
    private static final Logger log = LoggerFactory.getLogger(BulkFailedCopyProcessor.class);
    private ServerContext context;

    BulkFailedCopyProcessor(ServerContext context) {
        this.context = context;
    }

    public DistributedWorkQueue.Processor newProcessor() {
        return new BulkFailedCopyProcessor(this.context);
    }

    public void process(String workID, byte[] data) {
        String[] paths = new String(data, StandardCharsets.UTF_8).split(",");
        Path orig = new Path(paths[0]);
        Path dest = new Path(paths[1]);
        Path tmp = new Path(dest.getParent(), dest.getName() + ".tmp");
        VolumeManager vm = this.context.getVolumeManager();
        try {
            FileSystem origFs = vm.getFileSystemByPath(orig);
            FileSystem destFs = vm.getFileSystemByPath(dest);
            FileUtil.copy((FileSystem)origFs, (Path)orig, (FileSystem)destFs, (Path)tmp, (boolean)false, (boolean)true, (Configuration)this.context.getHadoopConf());
            destFs.rename(tmp, dest);
            log.debug("copied {} to {}", (Object)orig, (Object)dest);
        }
        catch (IOException ex) {
            try {
                FileSystem destFs = vm.getFileSystemByPath(dest);
                destFs.create(dest).close();
                log.warn(" marked " + dest + " failed", (Throwable)ex);
            }
            catch (IOException e) {
                log.error("Unable to create failure flag file " + dest, (Throwable)e);
            }
        }
    }
}

