/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.tableImport;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.tableImport.ImportedTableInfo;
import org.apache.accumulo.manager.tableOps.tableImport.MoveExportedFiles;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PopulateMetadataTable
extends ManagerRepo {
    private static final Logger log = LoggerFactory.getLogger(PopulateMetadataTable.class);
    private static final long serialVersionUID = 1L;
    private final ImportedTableInfo tableInfo;

    PopulateMetadataTable(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    static void readMappingFile(VolumeManager fs, ImportedTableInfo tableInfo, String importDir, Map<String, String> fileNameMappings) throws Exception {
        try (FSDataInputStream fsDis = fs.open(new Path(importDir, "mappings.txt"));
             InputStreamReader isr = new InputStreamReader((InputStream)fsDis, StandardCharsets.UTF_8);
             BufferedReader in = new BufferedReader(isr);){
            String line;
            while ((line = in.readLine()) != null) {
                String[] sa = line.split(":", 2);
                String prev = fileNameMappings.put(sa[0], importDir + "/" + sa[1]);
                if (prev == null) continue;
                String msg = "File exists in multiple import directories: '" + sa[0].replaceAll("[\r\n]", "") + "'";
                log.warn(msg);
                throw new AcceptableThriftTableOperationException(tableInfo.tableId.canonical(), tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, msg);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        Path path = new Path(this.tableInfo.exportFile);
        VolumeManager fs = manager.getVolumeManager();
        try (BatchWriter mbw = manager.getContext().createBatchWriter(MetadataTable.NAME);){
            MoveExportedFiles moveExportedFiles;
            try (ZipInputStream zis = new ZipInputStream((InputStream)fs.open(path));){
                ZipEntry zipEntry;
                HashMap<String, String> fileNameMappings = new HashMap<String, String>();
                for (ImportedTableInfo.DirectoryMapping dm : this.tableInfo.directories) {
                    log.info("importDir is " + dm.importDir);
                    PopulateMetadataTable.readMappingFile(fs, this.tableInfo, dm.importDir, fileNameMappings);
                }
                while ((zipEntry = zis.getNextEntry()) != null) {
                    Text endRow;
                    if (!zipEntry.getName().equals("metadata.bin")) continue;
                    DataInputStream in = new DataInputStream(new BufferedInputStream(zis));
                    Key key = new Key();
                    Value val = new Value();
                    Mutation m = null;
                    Text currentRow = null;
                    int dirCount = 0;
                    do {
                        Text cq;
                        key.readFields((DataInput)in);
                        val.readFields((DataInput)in);
                        endRow = KeyExtent.fromMetaRow((Text)key.getRow()).endRow();
                        Text metadataRow = new KeyExtent(this.tableInfo.tableId, endRow, null).toMetaRow();
                        if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                            String oldName = new Path(key.getColumnQualifier().toString()).getName();
                            String newName = (String)fileNameMappings.get(oldName);
                            if (newName == null) {
                                throw new AcceptableThriftTableOperationException(this.tableInfo.tableId.canonical(), this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "File " + oldName + " does not exist in import dir");
                            }
                            cq = new Text(newName);
                        } else {
                            cq = key.getColumnQualifier();
                        }
                        if (m == null || !currentRow.equals((Object)metadataRow)) {
                            if (m != null) {
                                mbw.addMutation(m);
                            }
                            String tabletDir = new String(FastFormat.toZeroPaddedString((long)dirCount++, (int)8, (int)16, (byte[])Constants.CLONE_PREFIX_BYTES), StandardCharsets.UTF_8);
                            m = new Mutation(metadataRow);
                            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value((CharSequence)tabletDir));
                            currentRow = metadataRow;
                        }
                        m.put(key.getColumnFamily(), cq, val);
                    } while (endRow != null || !MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key));
                    mbw.addMutation(m);
                    break;
                }
                moveExportedFiles = new MoveExportedFiles(this.tableInfo);
            }
            return moveExportedFiles;
        }
        catch (IOException ioe) {
            log.warn("{}", (Object)ioe.getMessage(), (Object)ioe);
            throw new AcceptableThriftTableOperationException(this.tableInfo.tableId.canonical(), this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Error reading " + path + " " + ioe.getMessage());
        }
    }

    @Override
    public void undo(long tid, Manager environment) throws Exception {
        MetadataTableUtil.deleteTable((TableId)this.tableInfo.tableId, (boolean)false, (ServerContext)environment.getContext(), (ServiceLock)environment.getManagerLock());
    }
}

