/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.compact;

import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.compact.CompactRange;
import org.apache.accumulo.manager.tableOps.delete.PreDeleteTable;
import org.apache.accumulo.server.manager.LiveTServerSet;
import org.apache.thrift.TException;
import org.slf4j.LoggerFactory;

class CompactionDriver
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private long compactId;
    private final TableId tableId;
    private final NamespaceId namespaceId;
    private byte[] startRow;
    private byte[] endRow;

    public static String createCompactionCancellationPath(InstanceId instanceId, TableId tableId) {
        return "/accumulo/" + instanceId + "/tables/" + tableId.canonical() + "/compact-cancel-id";
    }

    public CompactionDriver(long compactId, NamespaceId namespaceId, TableId tableId, byte[] startRow, byte[] endRow) {
        this.compactId = compactId;
        this.tableId = tableId;
        this.namespaceId = namespaceId;
        this.startRow = startRow;
        this.endRow = endRow;
    }

    @Override
    public long isReady(long tid, Manager manager) throws Exception {
        if (this.tableId.equals((Object)RootTable.ID)) {
            return 0L;
        }
        String zCancelID = CompactionDriver.createCompactionCancellationPath(manager.getInstanceID(), this.tableId);
        ZooReaderWriter zoo = manager.getContext().getZooReaderWriter();
        if (Long.parseLong(new String(zoo.getData(zCancelID))) >= this.compactId) {
            throw new AcceptableThriftTableOperationException(this.tableId.canonical(), null, TableOperation.COMPACT, TableOperationExceptionType.OTHER, "Compaction canceled");
        }
        String deleteMarkerPath = PreDeleteTable.createDeleteMarkerPath(manager.getInstanceID(), this.tableId);
        if (zoo.exists(deleteMarkerPath)) {
            throw new AcceptableThriftTableOperationException(this.tableId.canonical(), null, TableOperation.COMPACT, TableOperationExceptionType.OTHER, "Table is being deleted");
        }
        MapCounter serversToFlush = new MapCounter();
        long t1 = System.currentTimeMillis();
        int tabletsToWaitFor = 0;
        int tabletCount = 0;
        TabletsMetadata tablets = TabletsMetadata.builder((AccumuloClient)manager.getContext()).forTable(this.tableId).overlapping(this.startRow, this.endRow).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.LOCATION, TabletMetadata.ColumnType.PREV_ROW, TabletMetadata.ColumnType.COMPACT_ID}).build();
        for (TabletMetadata tablet : tablets) {
            if (tablet.getCompactId().orElse(-1L) < this.compactId) {
                ++tabletsToWaitFor;
                if (tablet.hasCurrent()) {
                    serversToFlush.increment((Object)tablet.getLocation().getServerInstance(), 1L);
                }
            }
            ++tabletCount;
        }
        long scanTime = System.currentTimeMillis() - t1;
        manager.getContext().clearTableListCache();
        if (tabletCount == 0 && !manager.getContext().tableNodeExists(this.tableId)) {
            throw new AcceptableThriftTableOperationException(this.tableId.canonical(), null, TableOperation.COMPACT, TableOperationExceptionType.NOTFOUND, null);
        }
        if (serversToFlush.size() == 0 && manager.getContext().getTableState(this.tableId) == TableState.OFFLINE) {
            throw new AcceptableThriftTableOperationException(this.tableId.canonical(), null, TableOperation.COMPACT, TableOperationExceptionType.OFFLINE, null);
        }
        if (tabletsToWaitFor == 0) {
            return 0L;
        }
        for (TServerInstance tsi : serversToFlush.keySet()) {
            try {
                LiveTServerSet.TServerConnection server = manager.getConnection(tsi);
                if (server == null) continue;
                server.compact(manager.getManagerLock(), this.tableId.canonical(), this.startRow, this.endRow);
            }
            catch (TException ex) {
                LoggerFactory.getLogger(CompactionDriver.class).error(ex.toString());
            }
        }
        long sleepTime = 500L;
        if (serversToFlush.size() > 0) {
            sleepTime = serversToFlush.max() * sleepTime;
        }
        sleepTime = Math.max(2L * scanTime, sleepTime);
        sleepTime = Math.min(sleepTime, 30000L);
        return sleepTime;
    }

    @Override
    public Repo<Manager> call(long tid, Manager env) throws Exception {
        CompactRange.removeIterators(env, tid, this.tableId);
        Utils.getReadLock(env, this.tableId, tid).unlock();
        Utils.getReadLock(env, this.namespaceId, tid).unlock();
        return null;
    }

    @Override
    public void undo(long tid, Manager environment) {
    }
}

