/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.gc.ReferenceFile;
import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.logging.TabletLogger;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.manager.thrift.ManagerState;
import org.apache.accumulo.core.manager.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.TabletState;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.manager.EventCoordinator;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.state.MergeStats;
import org.apache.accumulo.manager.state.TableCounts;
import org.apache.accumulo.manager.state.TableStats;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.gc.AllVolumesDirectory;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.manager.LiveTServerSet;
import org.apache.accumulo.server.manager.state.Assignment;
import org.apache.accumulo.server.manager.state.ClosableIterator;
import org.apache.accumulo.server.manager.state.DistributedStoreException;
import org.apache.accumulo.server.manager.state.MergeInfo;
import org.apache.accumulo.server.manager.state.MergeState;
import org.apache.accumulo.server.manager.state.TabletStateStore;
import org.apache.accumulo.server.manager.state.UnassignedTablet;
import org.apache.accumulo.server.tablets.TabletTime;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;

abstract class TabletGroupWatcher
extends Threads.AccumuloDaemonThread {
    private final Manager manager;
    private final TabletStateStore store;
    private final TabletGroupWatcher dependentWatcher;
    final TableStats stats = new TableStats();
    private SortedSet<TServerInstance> lastScanServers = Collections.emptySortedSet();

    TabletGroupWatcher(Manager manager, TabletStateStore store, TabletGroupWatcher dependentWatcher) {
        super("Watching " + store.name());
        this.manager = manager;
        this.store = store;
        this.dependentWatcher = dependentWatcher;
    }

    abstract boolean canSuspendTablets();

    Map<TableId, TableCounts> getStats() {
        return this.stats.getLast();
    }

    TableCounts getStats(TableId tableId) {
        return this.stats.getLast(tableId);
    }

    synchronized boolean isSameTserversAsLastScan(Set<TServerInstance> candidates) {
        return candidates.equals(this.lastScanServers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int[] oldCounts = new int[TabletState.values().length];
        EventCoordinator.Listener eventListener = this.manager.nextEvent.getListener();
        WalStateManager wals = new WalStateManager(this.manager.getContext());
        while (this.manager.stillManager()) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            long waitTimeBetweenScans = this.manager.getConfiguration().getTimeInMillis(Property.MANAGER_TABLET_GROUP_WATCHER_INTERVAL);
            int totalUnloaded = 0;
            int unloaded = 0;
            ClosableIterator iter = null;
            try {
                Object merge22;
                HashMap<TableId, MergeStats> mergeStatsCache = new HashMap<TableId, MergeStats>();
                HashMap<TableId, MergeStats> currentMerges = new HashMap<TableId, MergeStats>();
                for (Object merge22 : this.manager.merges()) {
                    if (merge22.getExtent() == null) continue;
                    currentMerges.put(merge22.getExtent().tableId(), new MergeStats((MergeInfo)merge22));
                }
                TreeMap<TServerInstance, TabletServerStatus> currentTServers = new TreeMap<TServerInstance, TabletServerStatus>();
                merge22 = this.manager.tserverSet.getCurrentServers().iterator();
                while (merge22.hasNext()) {
                    TServerInstance entry = (TServerInstance)merge22.next();
                    currentTServers.put(entry, (TabletServerStatus)this.manager.tserverStatus.get(entry));
                }
                if (currentTServers.isEmpty()) {
                    eventListener.waitForEvents(waitTimeBetweenScans);
                    merge22 = this;
                    synchronized (merge22) {
                        this.lastScanServers = Collections.emptySortedSet();
                        continue;
                    }
                }
                TabletLists tLists = new TabletLists(this.manager, currentTServers);
                ManagerState managerState = this.manager.getManagerState();
                int[] counts = new int[TabletState.values().length];
                this.stats.begin();
                for (TabletLocationState tabletLocationState : this.store) {
                    if (tabletLocationState == null || this.manager.getTableManager().getTableState(tabletLocationState.extent.tableId()) == null) continue;
                    if (tLists.unassigned.size() + unloaded > 5000 * currentTServers.size()) {
                        this.flushChanges(tLists, wals);
                        tLists.reset();
                        unloaded = 0;
                        eventListener.waitForEvents(waitTimeBetweenScans);
                    }
                    TableId tableId = tabletLocationState.extent.tableId();
                    TableConfiguration tableConf = this.manager.getContext().getTableConfiguration(tableId);
                    MergeStats mergeStats = mergeStatsCache.computeIfAbsent(tableId, k -> {
                        MergeStats mStats = (MergeStats)currentMerges.get(k);
                        return mStats != null ? mStats : new MergeStats(new MergeInfo());
                    });
                    Manager.TabletGoalState goal = this.manager.getGoalState(tabletLocationState, mergeStats.getMergeInfo());
                    TabletMetadata.Location location = tabletLocationState.getLocation();
                    TabletState state = tabletLocationState.getState(currentTServers.keySet());
                    TabletLogger.missassigned((KeyExtent)tabletLocationState.extent, (String)goal.toString(), (String)state.toString(), (TServerInstance)tabletLocationState.getFutureServer(), (TServerInstance)tabletLocationState.getCurrentServer(), (int)tabletLocationState.walogs.size());
                    this.stats.update(tableId, state);
                    mergeStats.update(tabletLocationState.extent, state, tabletLocationState.chopped, !tabletLocationState.walogs.isEmpty());
                    this.sendChopRequest(mergeStats.getMergeInfo(), state, tabletLocationState);
                    this.sendSplitRequest(mergeStats.getMergeInfo(), state, tabletLocationState);
                    if (state == TabletState.ASSIGNED) {
                        goal = Manager.TabletGoalState.HOSTED;
                    }
                    if (Manager.log.isTraceEnabled()) {
                        Manager.log.trace("[{}] Shutting down all Tservers: {}, dependentCount: {} Extent: {}, state: {}, goal: {}", new Object[]{this.store.name(), this.manager.serversToShutdown.equals(currentTServers.keySet()), this.dependentWatcher == null ? "null" : Integer.valueOf(this.dependentWatcher.assignedOrHosted()), tabletLocationState.extent, state, goal});
                    }
                    if (goal == Manager.TabletGoalState.SUSPENDED && state == TabletState.HOSTED && this.manager.serversToShutdown.equals(currentTServers.keySet()) && this.dependentWatcher != null) {
                        Ample.DataLevel dependentLevel = this.dependentWatcher.store.getLevel();
                        boolean userTablesExist = true;
                        switch (dependentLevel) {
                            case USER: {
                                Set<TableId> onlineTables = this.manager.onlineTables();
                                onlineTables.remove(RootTable.ID);
                                onlineTables.remove(MetadataTable.ID);
                                userTablesExist = !onlineTables.isEmpty();
                                break;
                            }
                        }
                        Map<TableId, TableCounts> stats = this.dependentWatcher.getStats();
                        if (dependentLevel == Ample.DataLevel.USER) {
                            if (userTablesExist && (stats == null || stats.isEmpty() || this.assignedOrHosted(stats) > 0)) {
                                goal = Manager.TabletGoalState.HOSTED;
                            }
                        } else if (stats == null || stats.isEmpty() || this.assignedOrHosted(stats) > 0) {
                            goal = Manager.TabletGoalState.HOSTED;
                        }
                    }
                    if (goal == Manager.TabletGoalState.HOSTED) {
                        if (state != TabletState.HOSTED && !tabletLocationState.walogs.isEmpty() && this.manager.recoveryManager.recoverLogs(tabletLocationState.extent, tabletLocationState.walogs)) continue;
                        switch (state) {
                            case HOSTED: {
                                if (!location.getServerInstance().equals(this.manager.migrations.get(tabletLocationState.extent))) break;
                                this.manager.migrations.remove(tabletLocationState.extent);
                                break;
                            }
                            case ASSIGNED_TO_DEAD_SERVER: {
                                this.hostDeadTablet(tLists, tabletLocationState, location, wals);
                                break;
                            }
                            case SUSPENDED: {
                                this.hostSuspendedTablet(tLists, tabletLocationState, location, tableConf);
                                break;
                            }
                            case UNASSIGNED: {
                                this.hostUnassignedTablet(tLists, tabletLocationState.extent, new UnassignedTablet(location, tabletLocationState.last));
                                break;
                            }
                            case ASSIGNED: {
                                tLists.assigned.add(new Assignment(tabletLocationState.extent, tabletLocationState.getFutureServer(), tabletLocationState.last));
                            }
                        }
                    } else {
                        switch (state) {
                            case SUSPENDED: {
                                tLists.suspendedToGoneServers.add(tabletLocationState);
                                this.cancelOfflineTableMigrations(tabletLocationState.extent);
                                break;
                            }
                            case UNASSIGNED: {
                                this.cancelOfflineTableMigrations(tabletLocationState.extent);
                                break;
                            }
                            case ASSIGNED_TO_DEAD_SERVER: {
                                this.unassignDeadTablet(tLists, tabletLocationState, wals);
                                break;
                            }
                            case HOSTED: {
                                LiveTServerSet.TServerConnection client = this.manager.tserverSet.getConnection(location.getServerInstance());
                                if (client != null) {
                                    Manager.log.trace("[{}] Requesting TabletServer {} unload {} {}", new Object[]{this.store.name(), location.getServerInstance(), tabletLocationState.extent, goal.howUnload()});
                                    client.unloadTablet(this.manager.managerLock, tabletLocationState.extent, goal.howUnload(), this.manager.getSteadyTime().longValue());
                                    ++unloaded;
                                    ++totalUnloaded;
                                    break;
                                }
                                Manager.log.warn("Could not connect to server {}", (Object)location);
                                break;
                            }
                        }
                    }
                    int n = state.ordinal();
                    counts[n] = counts[n] + 1;
                }
                this.flushChanges(tLists, wals);
                this.stats.end(managerState);
                Manager.log.trace("[{}] End stats collection: {}", (Object)this.store.name(), (Object)this.stats);
                for (TabletState state : TabletState.values()) {
                    int i = state.ordinal();
                    if (counts[i] <= 0 || counts[i] == oldCounts[i]) continue;
                    this.manager.nextEvent.event("[%s]: %d tablets are %s", this.store.name(), counts[i], state.name());
                }
                Manager.log.debug(String.format("[%s]: scan time %.2f seconds", this.store.name(), (double)this.stats.getScanTime() / 1000.0));
                oldCounts = counts;
                if (totalUnloaded > 0) {
                    this.manager.nextEvent.event("[%s]: %d tablets unloaded", this.store.name(), totalUnloaded);
                }
                this.updateMergeState(mergeStatsCache);
                TabletGroupWatcher object = this;
                synchronized (object) {
                    this.lastScanServers = ImmutableSortedSet.copyOf(currentTServers.keySet());
                }
                if (this.manager.tserverSet.getCurrentServers().equals(currentTServers.keySet())) {
                    Manager.log.debug(String.format("[%s] sleeping for %.2f seconds", this.store.name(), (double)waitTimeBetweenScans / 1000.0));
                    eventListener.waitForEvents(waitTimeBetweenScans);
                    continue;
                }
                Manager.log.info("Detected change in current tserver set, re-running state machine.");
            }
            catch (Exception ex) {
                Manager.log.error("Error processing table state for store " + this.store.name(), (Throwable)ex);
                if (ex.getCause() != null && ex.getCause() instanceof TabletLocationState.BadLocationStateException) {
                    this.repairMetadata(((TabletLocationState.BadLocationStateException)ex.getCause()).getEncodedEndRow());
                    continue;
                }
                Uninterruptibles.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            finally {
                if (iter == null) continue;
                try {
                    iter.close();
                }
                catch (IOException ex) {
                    Manager.log.warn("Error closing TabletLocationState iterator: " + ex, (Throwable)ex);
                }
            }
        }
    }

    private void unassignDeadTablet(TabletLists tLists, TabletLocationState tls, WalStateManager wals) throws WalStateManager.WalMarkerException {
        tLists.assignedToDeadServers.add(tls);
        if (!tLists.logsForDeadServers.containsKey(tls.futureOrCurrentServer())) {
            tLists.logsForDeadServers.put(tls.futureOrCurrentServer(), wals.getWalsInUse(tls.futureOrCurrentServer()));
        }
    }

    private void hostUnassignedTablet(TabletLists tLists, KeyExtent tablet, UnassignedTablet unassignedTablet) {
        TServerInstance dest = (TServerInstance)this.manager.migrations.get(tablet);
        if (dest != null) {
            if (tLists.destinations.containsKey(dest)) {
                tLists.assignments.add(new Assignment(tablet, dest, unassignedTablet.getLastLocation()));
            } else {
                this.manager.migrations.remove(tablet);
                tLists.unassigned.put(tablet, unassignedTablet);
            }
        } else {
            tLists.unassigned.put(tablet, unassignedTablet);
        }
    }

    private void hostSuspendedTablet(TabletLists tLists, TabletLocationState tls, TabletMetadata.Location location, TableConfiguration tableConf) {
        if (this.manager.getSteadyTime() - tls.suspend.suspensionTime < tableConf.getTimeInMillis(Property.TABLE_SUSPEND_DURATION)) {
            TServerInstance found;
            TServerInstance returnInstance = null;
            Iterator<TServerInstance> find = tLists.destinations.tailMap(new TServerInstance(tls.suspend.server, " ")).keySet().iterator();
            if (find.hasNext() && (found = find.next()).getHostAndPort().equals((Object)tls.suspend.server)) {
                returnInstance = found;
            }
            if (returnInstance != null) {
                tLists.assignments.add(new Assignment(tls.extent, returnInstance, tls.last));
            }
        } else {
            tLists.unassigned.put(tls.extent, new UnassignedTablet(location, tls.last));
        }
    }

    private void hostDeadTablet(TabletLists tLists, TabletLocationState tls, TabletMetadata.Location location, WalStateManager wals) throws WalStateManager.WalMarkerException {
        TServerInstance tserver;
        tLists.assignedToDeadServers.add(tls);
        if (location.getServerInstance().equals(this.manager.migrations.get(tls.extent))) {
            this.manager.migrations.remove(tls.extent);
        }
        if (!tLists.logsForDeadServers.containsKey(tserver = tls.futureOrCurrentServer())) {
            tLists.logsForDeadServers.put(tserver, wals.getWalsInUse(tserver));
        }
    }

    private void cancelOfflineTableMigrations(KeyExtent extent) {
        TServerInstance dest = (TServerInstance)this.manager.migrations.get(extent);
        TableState tableState = this.manager.getTableManager().getTableState(extent.tableId());
        if (dest != null && tableState == TableState.OFFLINE) {
            this.manager.migrations.remove(extent);
        }
    }

    private void repairMetadata(Text row) {
        Manager.log.debug("Attempting repair on {}", (Object)row);
        try {
            HashMap<Key, Value> future = new HashMap<Key, Value>();
            HashMap<Key, Value> assigned = new HashMap<Key, Value>();
            KeyExtent extent = KeyExtent.fromMetaRow((Text)row);
            String table = MetadataTable.NAME;
            if (extent.isMeta()) {
                table = RootTable.NAME;
            }
            Scanner scanner = this.manager.getContext().createScanner(table, Authorizations.EMPTY);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME);
            scanner.setRange(new Range(row));
            for (Map.Entry entry : scanner) {
                if (((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                    assigned.put((Key)entry.getKey(), (Value)entry.getValue());
                    continue;
                }
                if (!((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME)) continue;
                future.put((Key)entry.getKey(), (Value)entry.getValue());
            }
            if (!future.isEmpty() && !assigned.isEmpty()) {
                Manager.log.warn("Found a tablet assigned and hosted, attempting to repair");
            } else if (future.size() > 1 && assigned.isEmpty()) {
                Manager.log.warn("Found a tablet assigned to multiple servers, attempting to repair");
            } else if (future.isEmpty() && assigned.size() > 1) {
                Manager.log.warn("Found a tablet hosted on multiple servers, attempting to repair");
            } else {
                Manager.log.info("Attempted a repair, but nothing seems to be obviously wrong. {} {}", assigned, future);
                return;
            }
            Iterator iter = Iterators.concat(future.entrySet().iterator(), assigned.entrySet().iterator());
            while (iter.hasNext()) {
                Map.Entry entry;
                entry = (Map.Entry)iter.next();
                TServerInstance alive = this.manager.tserverSet.find(((Value)entry.getValue()).toString());
                if (alive != null) continue;
                Manager.log.info("Removing entry  {}", (Object)entry);
                BatchWriter bw = this.manager.getContext().createBatchWriter(table);
                Mutation m = new Mutation(((Key)entry.getKey()).getRow());
                m.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier());
                bw.addMutation(m);
                bw.close();
                return;
            }
            Manager.log.error("Metadata table is inconsistent at {} and all assigned/future tservers are still online.", (Object)row);
        }
        catch (Exception e) {
            Manager.log.error("Error attempting repair of metadata " + row + ": " + e, (Throwable)e);
        }
    }

    private int assignedOrHosted() {
        return this.assignedOrHosted(this.stats.getLast());
    }

    private int assignedOrHosted(Map<TableId, TableCounts> last) {
        int result = 0;
        for (TableCounts counts : last.values()) {
            result += counts.assigned() + counts.hosted();
        }
        return result;
    }

    private void sendSplitRequest(MergeInfo info, TabletState state, TabletLocationState tls) {
        if (!info.getState().equals((Object)MergeState.SPLITTING)) {
            return;
        }
        if (!info.isDelete()) {
            return;
        }
        if (!state.equals((Object)TabletState.HOSTED)) {
            return;
        }
        KeyExtent range = info.getExtent();
        if (tls.extent.overlaps(range)) {
            for (Text splitPoint : new Text[]{range.prevEndRow(), range.endRow()}) {
                if (splitPoint == null || !tls.extent.contains((BinaryComparable)splitPoint) || splitPoint.equals((Object)tls.extent.endRow()) || splitPoint.equals((Object)tls.extent.prevEndRow())) continue;
                try {
                    LiveTServerSet.TServerConnection conn = this.manager.tserverSet.getConnection(tls.getCurrentServer());
                    if (conn != null) {
                        Manager.log.info("Asking {} to split {} at {}", new Object[]{tls.current, tls.extent, splitPoint});
                        conn.splitTablet(tls.extent, splitPoint);
                        continue;
                    }
                    Manager.log.warn("Not connected to server {}", (Object)tls.current);
                }
                catch (NotServingTabletException e) {
                    Manager.log.debug("Error asking tablet server to split a tablet: ", (Throwable)e);
                }
                catch (Exception e) {
                    Manager.log.warn("Error asking tablet server to split a tablet: ", (Throwable)e);
                }
            }
        }
    }

    private void sendChopRequest(MergeInfo info, TabletState state, TabletLocationState tls) {
        if (!info.getState().equals((Object)MergeState.WAITING_FOR_CHOPPED)) {
            return;
        }
        if (!state.equals((Object)TabletState.HOSTED)) {
            return;
        }
        if (tls.chopped) {
            return;
        }
        if (info.needsToBeChopped(tls.extent)) {
            try {
                LiveTServerSet.TServerConnection conn = this.manager.tserverSet.getConnection(tls.getCurrentServer());
                if (conn != null) {
                    Manager.log.info("Asking {} to chop {}", (Object)tls.current, (Object)tls.extent);
                    conn.chop(this.manager.managerLock, tls.extent);
                } else {
                    Manager.log.warn("Could not connect to server {}", (Object)tls.current);
                }
            }
            catch (TException e) {
                Manager.log.warn("Communications error asking tablet server to chop a tablet");
            }
        }
    }

    private void updateMergeState(Map<TableId, MergeStats> mergeStatsCache) {
        for (MergeStats stats : mergeStatsCache.values()) {
            try {
                MergeState update = stats.nextMergeState((AccumuloClient)this.manager.getContext(), this.manager);
                if (update == MergeState.COMPLETE) {
                    update = MergeState.NONE;
                }
                if (update != stats.getMergeInfo().getState()) {
                    this.manager.setMergeState(stats.getMergeInfo(), update);
                }
                if (update != MergeState.MERGING) continue;
                try {
                    if (stats.getMergeInfo().isDelete()) {
                        this.deleteTablets(stats.getMergeInfo());
                    } else {
                        this.mergeMetadataRecords(stats.getMergeInfo());
                    }
                    update = MergeState.COMPLETE;
                    this.manager.setMergeState(stats.getMergeInfo(), update);
                }
                catch (Exception ex) {
                    Manager.log.error("Unable merge metadata table records", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                Manager.log.error("Unable to update merge state for merge " + stats.getMergeInfo().getExtent(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTablets(MergeInfo info) throws AccumuloException {
        block16: {
            KeyExtent extent = info.getExtent();
            String targetSystemTable = extent.isMeta() ? RootTable.NAME : MetadataTable.NAME;
            Manager.log.debug("Deleting tablets for {}", (Object)extent);
            MetadataTime metadataTime = null;
            KeyExtent followingTablet = null;
            if (extent.endRow() != null) {
                Key nextExtent = new Key(extent.endRow()).followingKey(PartialKey.ROW);
                followingTablet = this.getHighTablet(new KeyExtent(extent.tableId(), nextExtent.getRow(), extent.endRow()));
                Manager.log.debug("Found following tablet {}", (Object)followingTablet);
            }
            try {
                ServerContext client = this.manager.getContext();
                ServerContext context = this.manager.getContext();
                Ample ample = context.getAmple();
                Text start = extent.prevEndRow();
                if (start == null) {
                    start = new Text();
                }
                Manager.log.debug("Making file deletion entries for {}", (Object)extent);
                Range deleteRange = new Range(MetadataSchema.TabletsSection.encodeRow((TableId)extent.tableId(), (Text)start), false, MetadataSchema.TabletsSection.encodeRow((TableId)extent.tableId(), (Text)extent.endRow()), true);
                Scanner scanner = client.createScanner(targetSystemTable, Authorizations.EMPTY);
                scanner.setRange(deleteRange);
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
                MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.fetch((ScannerBase)scanner);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
                TreeSet<Object> datafilesAndDirs = new TreeSet<Object>();
                for (Map.Entry entry : scanner) {
                    Key key = (Key)entry.getKey();
                    if (key.compareColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME) == 0) {
                        StoredTabletFile stf = new StoredTabletFile(key.getColumnQualifierData().toString());
                        datafilesAndDirs.add(new ReferenceFile(stf.getTableId(), stf.getMetaUpdateDelete()));
                        if (datafilesAndDirs.size() <= 1000) continue;
                        ample.putGcFileAndDirCandidates(extent.tableId(), datafilesAndDirs);
                        datafilesAndDirs.clear();
                        continue;
                    }
                    if (MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns(key)) {
                        metadataTime = MetadataTime.parse((String)((Value)entry.getValue()).toString());
                        continue;
                    }
                    if (key.compareColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME) == 0) {
                        throw new IllegalStateException("Tablet " + key.getRow() + " is assigned during a merge!");
                    }
                    if (!MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) continue;
                    AllVolumesDirectory allVolumesDirectory = new AllVolumesDirectory(extent.tableId(), ((Value)entry.getValue()).toString());
                    datafilesAndDirs.add(allVolumesDirectory);
                    if (datafilesAndDirs.size() <= 1000) continue;
                    ample.putGcFileAndDirCandidates(extent.tableId(), datafilesAndDirs);
                    datafilesAndDirs.clear();
                }
                ample.putGcFileAndDirCandidates(extent.tableId(), datafilesAndDirs);
                try (BatchWriter bw = client.createBatchWriter(targetSystemTable);){
                    this.deleteTablets(info, deleteRange, bw, (AccumuloClient)client);
                }
                if (followingTablet != null) {
                    Manager.log.debug("Updating prevRow of {} to {}", (Object)followingTablet, (Object)extent.prevEndRow());
                    bw = client.createBatchWriter(targetSystemTable);
                    try {
                        Mutation m = new Mutation(followingTablet.toMetaRow());
                        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.put(m, MetadataSchema.TabletsSection.TabletColumnFamily.encodePrevEndRow((Text)extent.prevEndRow()));
                        MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.putDelete(m);
                        bw.addMutation(m);
                        bw.flush();
                        break block16;
                    }
                    finally {
                        bw.close();
                    }
                }
                MetadataTableUtil.addTablet((KeyExtent)new KeyExtent(extent.tableId(), null, extent.prevEndRow()), (String)"default_tablet", (ServerContext)this.manager.getContext(), (TimeType)metadataTime.getType(), (ServiceLock)this.manager.managerLock);
            }
            catch (RuntimeException | TableNotFoundException ex) {
                throw new AccumuloException(ex);
            }
        }
    }

    private void mergeMetadataRecords(MergeInfo info) throws AccumuloException {
        KeyExtent range = info.getExtent();
        Manager.log.debug("Merging metadata for {}", (Object)range);
        KeyExtent stop = this.getHighTablet(range);
        Manager.log.debug("Highest tablet is {}", (Object)stop);
        Value firstPrevRowValue = null;
        Text stopRow = stop.toMetaRow();
        Text start = range.prevEndRow();
        if (start == null) {
            start = new Text();
        }
        Range scanRange = new Range(MetadataSchema.TabletsSection.encodeRow((TableId)range.tableId(), (Text)start), false, stopRow, false);
        String targetSystemTable = MetadataTable.NAME;
        if (range.isMeta()) {
            targetSystemTable = RootTable.NAME;
        }
        ServerContext client = this.manager.getContext();
        try (BatchWriter bw = client.createBatchWriter(targetSystemTable);){
            long fileCount = 0L;
            Scanner scanner = client.createScanner(targetSystemTable, Authorizations.EMPTY);
            scanner.setRange(scanRange);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.fetch((ScannerBase)scanner);
            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            Mutation m = new Mutation(stopRow);
            MetadataTime maxLogicalTime = null;
            for (Object entry : scanner) {
                Key key = (Key)entry.getKey();
                Value value = (Value)entry.getValue();
                if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                    m.put(key.getColumnFamily(), key.getColumnQualifier(), value);
                    ++fileCount;
                    continue;
                }
                if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key) && firstPrevRowValue == null) {
                    Manager.log.debug("prevRow entry for lowest tablet is {}", (Object)value);
                    firstPrevRowValue = new Value(value);
                    continue;
                }
                if (MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns(key)) {
                    maxLogicalTime = TabletTime.maxMetadataTime(maxLogicalTime, (MetadataTime)MetadataTime.parse((String)value.toString()));
                    continue;
                }
                if (!MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) continue;
                AllVolumesDirectory allVolumesDir = new AllVolumesDirectory(range.tableId(), value.toString());
                bw.addMutation(this.manager.getContext().getAmple().createDeleteMutation((ReferenceFile)allVolumesDir));
            }
            scanner = client.createScanner(targetSystemTable, Authorizations.EMPTY);
            scanner.setRange(new Range(stopRow));
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.fetch((ScannerBase)scanner);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.ExternalCompactionColumnFamily.NAME);
            HashSet<String> extCompIds = new HashSet<String>();
            for (Map.Entry entry : scanner) {
                if (MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns((Key)entry.getKey())) {
                    maxLogicalTime = TabletTime.maxMetadataTime((MetadataTime)maxLogicalTime, (MetadataTime)MetadataTime.parse((String)((Value)entry.getValue()).toString()));
                    continue;
                }
                if (!MetadataSchema.TabletsSection.ExternalCompactionColumnFamily.NAME.equals((Object)((Key)entry.getKey()).getColumnFamily())) continue;
                extCompIds.add(((Key)entry.getKey()).getColumnQualifierData().toString());
            }
            if (maxLogicalTime != null) {
                MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value((CharSequence)maxLogicalTime.encode()));
            }
            extCompIds.forEach(ecid -> m.putDelete((CharSequence)"ecomp", (CharSequence)ecid));
            if (!m.getUpdates().isEmpty()) {
                bw.addMutation(m);
            }
            bw.flush();
            Manager.log.debug("Moved {} files to {}", (Object)fileCount, (Object)stop);
            if (firstPrevRowValue == null) {
                Manager.log.debug("tablet already merged");
                return;
            }
            stop = new KeyExtent(stop.tableId(), stop.endRow(), MetadataSchema.TabletsSection.TabletColumnFamily.decodePrevEndRow((Value)firstPrevRowValue));
            Mutation updatePrevRow = MetadataSchema.TabletsSection.TabletColumnFamily.createPrevRowMutation((KeyExtent)stop);
            Manager.log.debug("Setting the prevRow for last tablet: {}", (Object)stop);
            bw.addMutation(updatePrevRow);
            bw.flush();
            this.deleteTablets(info, scanRange, bw, (AccumuloClient)client);
            Mutation m2 = new Mutation(stopRow);
            MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.putDelete(m2);
            bw.addMutation(m2);
            bw.flush();
        }
        catch (Exception ex) {
            throw new AccumuloException((Throwable)ex);
        }
    }

    private void deleteTablets(MergeInfo info, Range scanRange, BatchWriter bw, AccumuloClient client) throws TableNotFoundException, MutationsRejectedException {
        Scanner scanner = client.createScanner(info.getExtent().isMeta() ? RootTable.NAME : MetadataTable.NAME, Authorizations.EMPTY);
        Manager.log.debug("Deleting range {}", (Object)scanRange);
        scanner.setRange(scanRange);
        RowIterator rowIter = new RowIterator((Iterable)scanner);
        while (rowIter.hasNext()) {
            Iterator row = rowIter.next();
            Mutation m = null;
            while (row.hasNext()) {
                Map.Entry entry = (Map.Entry)row.next();
                Key key = (Key)entry.getKey();
                if (m == null) {
                    m = new Mutation(key.getRow());
                }
                m.putDelete(key.getColumnFamily(), key.getColumnQualifier());
                Manager.log.debug("deleting entry {}", (Object)key);
            }
            bw.addMutation(m);
        }
        bw.flush();
    }

    private KeyExtent getHighTablet(KeyExtent range) throws AccumuloException {
        try {
            ServerContext client = this.manager.getContext();
            Scanner scanner = client.createScanner(range.isMeta() ? RootTable.NAME : MetadataTable.NAME, Authorizations.EMPTY);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
            KeyExtent start = new KeyExtent(range.tableId(), range.endRow(), null);
            scanner.setRange(new Range(start.toMetaRow(), null));
            Iterator iterator = scanner.iterator();
            if (!iterator.hasNext()) {
                throw new AccumuloException("No last tablet for a merge " + range);
            }
            Map.Entry entry = (Map.Entry)iterator.next();
            KeyExtent highTablet = KeyExtent.fromMetaPrevRow((Map.Entry)entry);
            if (!highTablet.tableId().equals((Object)range.tableId())) {
                throw new AccumuloException("No last tablet for merge " + range + " " + highTablet);
            }
            return highTablet;
        }
        catch (Exception ex) {
            throw new AccumuloException("Unexpected failure finding the last tablet for a merge " + range, (Throwable)ex);
        }
    }

    private void handleDeadTablets(TabletLists tLists, WalStateManager wals) throws WalStateManager.WalMarkerException, DistributedStoreException {
        int maxServersToShow;
        List<TabletLocationState> deadTablets = tLists.assignedToDeadServers;
        Map<TServerInstance, List<Path>> deadLogs = tLists.logsForDeadServers;
        if (!deadTablets.isEmpty()) {
            maxServersToShow = Math.min(deadTablets.size(), 100);
            Manager.log.debug("{} assigned to dead servers: {}...", (Object)deadTablets.size(), deadTablets.subList(0, maxServersToShow));
            Manager.log.debug("logs for dead servers: {}", deadLogs);
            if (this.canSuspendTablets()) {
                this.store.suspend(deadTablets, deadLogs, this.manager.getSteadyTime().longValue());
            } else {
                this.store.unassign(deadTablets, deadLogs);
            }
            TabletGroupWatcher.markDeadServerLogsAsClosed(wals, deadLogs);
            this.manager.nextEvent.event("Marked %d tablets as suspended because they don't have current servers", deadTablets.size());
        }
        if (!tLists.suspendedToGoneServers.isEmpty()) {
            maxServersToShow = Math.min(deadTablets.size(), 100);
            Manager.log.debug(deadTablets.size() + " suspended to gone servers: " + deadTablets.subList(0, maxServersToShow) + "...");
            this.store.unsuspend(tLists.suspendedToGoneServers);
        }
    }

    private void getAssignmentsFromBalancer(TabletLists tLists, Map<KeyExtent, UnassignedTablet> unassigned) {
        if (!tLists.destinations.isEmpty()) {
            HashMap<KeyExtent, TServerInstance> assignedOut = new HashMap<KeyExtent, TServerInstance>();
            this.manager.getAssignments(tLists.destinations, unassigned, assignedOut);
            for (Map.Entry assignment : assignedOut.entrySet()) {
                if (unassigned.containsKey(assignment.getKey())) {
                    if (assignment.getValue() == null) continue;
                    if (!tLists.destinations.containsKey(assignment.getValue())) {
                        Manager.log.warn("balancer assigned {} to a tablet server that is not current {} ignoring", assignment.getKey(), assignment.getValue());
                        continue;
                    }
                    UnassignedTablet unassignedTablet = unassigned.get(assignment.getKey());
                    tLists.assignments.add(new Assignment((KeyExtent)assignment.getKey(), (TServerInstance)assignment.getValue(), unassignedTablet != null ? unassignedTablet.getLastLocation() : null));
                    continue;
                }
                Manager.log.warn("{} load balancer assigning tablet that was not nominated for assignment {}", (Object)this.store.name(), assignment.getKey());
            }
            if (!unassigned.isEmpty() && assignedOut.isEmpty()) {
                Manager.log.warn("Load balancer failed to assign any tablets");
            }
        }
    }

    private void flushChanges(TabletLists tLists, WalStateManager wals) throws DistributedStoreException, TException, WalStateManager.WalMarkerException {
        Map<KeyExtent, UnassignedTablet> unassigned = Collections.unmodifiableMap(tLists.unassigned);
        this.handleDeadTablets(tLists, wals);
        this.getAssignmentsFromBalancer(tLists, unassigned);
        if (!tLists.assignments.isEmpty()) {
            Manager.log.info(String.format("Assigning %d tablets", tLists.assignments.size()));
            this.store.setFutureLocations(tLists.assignments);
        }
        tLists.assignments.addAll(tLists.assigned);
        for (Assignment a : tLists.assignments) {
            LiveTServerSet.TServerConnection client = this.manager.tserverSet.getConnection(a.server);
            if (client != null) {
                client.assignTablet(this.manager.managerLock, a.tablet);
            } else {
                Manager.log.warn("Could not connect to server {}", (Object)a.server);
            }
            this.manager.assignedTablet(a.tablet);
        }
    }

    private static void markDeadServerLogsAsClosed(WalStateManager mgr, Map<TServerInstance, List<Path>> logsForDeadServers) throws WalStateManager.WalMarkerException {
        for (Map.Entry<TServerInstance, List<Path>> server : logsForDeadServers.entrySet()) {
            for (Path path : server.getValue()) {
                mgr.closeWal(server.getKey(), path);
            }
        }
    }

    private static class TabletLists {
        private final List<Assignment> assignments = new ArrayList<Assignment>();
        private final List<Assignment> assigned = new ArrayList<Assignment>();
        private final List<TabletLocationState> assignedToDeadServers = new ArrayList<TabletLocationState>();
        private final List<TabletLocationState> suspendedToGoneServers = new ArrayList<TabletLocationState>();
        private final Map<KeyExtent, UnassignedTablet> unassigned = new HashMap<KeyExtent, UnassignedTablet>();
        private final Map<TServerInstance, List<Path>> logsForDeadServers = new TreeMap<TServerInstance, List<Path>>();
        private final SortedMap<TServerInstance, TabletServerStatus> destinations;

        public TabletLists(Manager m, SortedMap<TServerInstance, TabletServerStatus> curTServers) {
            TreeMap<TServerInstance, TabletServerStatus> destinationsMod = new TreeMap<TServerInstance, TabletServerStatus>(curTServers);
            destinationsMod.keySet().removeAll(m.serversToShutdown);
            this.destinations = Collections.unmodifiableSortedMap(destinationsMod);
        }

        public void reset() {
            this.assignments.clear();
            this.assigned.clear();
            this.assignedToDeadServers.clear();
            this.suspendedToGoneServers.clear();
            this.unassigned.clear();
        }
    }
}

