/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile.bcfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.crypto.CryptoEnvironmentImpl;
import org.apache.accumulo.core.crypto.CryptoUtils;
import org.apache.accumulo.core.file.rfile.bcfile.Compression;
import org.apache.accumulo.core.file.rfile.bcfile.CompressionAlgorithm;
import org.apache.accumulo.core.file.rfile.bcfile.MetaBlockAlreadyExists;
import org.apache.accumulo.core.file.rfile.bcfile.MetaBlockDoesNotExist;
import org.apache.accumulo.core.file.rfile.bcfile.SimpleBufferedOutputStream;
import org.apache.accumulo.core.file.rfile.bcfile.Utils;
import org.apache.accumulo.core.file.streams.BoundedRangeFileInputStream;
import org.apache.accumulo.core.file.streams.RateLimitedOutputStream;
import org.apache.accumulo.core.file.streams.SeekableDataInputStream;
import org.apache.accumulo.core.spi.crypto.CryptoEnvironment;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.spi.crypto.FileDecrypter;
import org.apache.accumulo.core.spi.crypto.FileEncrypter;
import org.apache.accumulo.core.spi.crypto.NoFileDecrypter;
import org.apache.accumulo.core.spi.crypto.NoFileEncrypter;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

public final class BCFile {
    static final Utils.Version API_VERSION_3 = new Utils.Version(3, 0);
    static final Utils.Version API_VERSION_2 = new Utils.Version(2, 0);
    static final Utils.Version API_VERSION_1 = new Utils.Version(1, 0);
    static final Log LOG = LogFactory.getLog(BCFile.class);
    private static final String FS_OUTPUT_BUF_SIZE_ATTR = "tfile.fs.output.buffer.size";
    private static final String FS_INPUT_BUF_SIZE_ATTR = "tfile.fs.input.buffer.size";

    private static int getFSOutputBufferSize(Configuration conf) {
        return conf.getInt(FS_OUTPUT_BUF_SIZE_ATTR, 262144);
    }

    private static int getFSInputBufferSize(Configuration conf) {
        return conf.getInt(FS_INPUT_BUF_SIZE_ATTR, 32768);
    }

    private BCFile() {
    }

    static final class BlockRegion {
        private final long offset;
        private final long compressedSize;
        private final long rawSize;

        public BlockRegion(DataInput in) throws IOException {
            this.offset = Utils.readVLong(in);
            this.compressedSize = Utils.readVLong(in);
            this.rawSize = Utils.readVLong(in);
        }

        public BlockRegion(long offset, long compressedSize, long rawSize) {
            this.offset = offset;
            this.compressedSize = compressedSize;
            this.rawSize = rawSize;
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeVLong(out, this.offset);
            Utils.writeVLong(out, this.compressedSize);
            Utils.writeVLong(out, this.rawSize);
        }

        public long getOffset() {
            return this.offset;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public long getRawSize() {
            return this.rawSize;
        }
    }

    static final class Magic {
        private static final byte[] AB_MAGIC_BCFILE = new byte[]{-47, 17, -45, 104, -111, -75, -41, -74, 57, -33, 65, 64, -110, -70, -31, 80};

        Magic() {
        }

        public static void readAndVerify(DataInput in) throws IOException {
            byte[] abMagic = new byte[Magic.size()];
            in.readFully(abMagic);
            if (!Arrays.equals(abMagic, AB_MAGIC_BCFILE)) {
                throw new IOException("Not a valid BCFile.");
            }
        }

        public static void write(DataOutput out) throws IOException {
            out.write(AB_MAGIC_BCFILE);
        }

        public static int size() {
            return AB_MAGIC_BCFILE.length;
        }
    }

    static class DataIndex {
        static final String BLOCK_NAME = "BCFile.index";
        private final CompressionAlgorithm defaultCompressionAlgorithm;
        private final ArrayList<BlockRegion> listRegions;

        public DataIndex(DataInput in) throws IOException {
            this.defaultCompressionAlgorithm = Compression.getCompressionAlgorithmByName(Utils.readString(in));
            int n = Utils.readVInt(in);
            this.listRegions = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                BlockRegion region = new BlockRegion(in);
                this.listRegions.add(region);
            }
        }

        public DataIndex(String defaultCompressionAlgorithmName) {
            this.defaultCompressionAlgorithm = Compression.getCompressionAlgorithmByName(defaultCompressionAlgorithmName);
            this.listRegions = new ArrayList();
        }

        public CompressionAlgorithm getDefaultCompressionAlgorithm() {
            return this.defaultCompressionAlgorithm;
        }

        public ArrayList<BlockRegion> getBlockRegionList() {
            return this.listRegions;
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeString(out, this.defaultCompressionAlgorithm.getName());
            Utils.writeVInt(out, this.listRegions.size());
            for (BlockRegion region : this.listRegions) {
                region.write(out);
            }
        }
    }

    static final class MetaIndexEntry {
        private final String metaName;
        private final CompressionAlgorithm compressionAlgorithm;
        private static final String defaultPrefix = "data:";
        private final BlockRegion region;

        public MetaIndexEntry(DataInput in) throws IOException {
            String fullMetaName = Utils.readString(in);
            if (!fullMetaName.startsWith(defaultPrefix)) {
                throw new IOException("Corrupted Meta region Index");
            }
            this.metaName = fullMetaName.substring(defaultPrefix.length(), fullMetaName.length());
            this.compressionAlgorithm = Compression.getCompressionAlgorithmByName(Utils.readString(in));
            this.region = new BlockRegion(in);
        }

        public MetaIndexEntry(String metaName, CompressionAlgorithm compressionAlgorithm, BlockRegion region) {
            this.metaName = metaName;
            this.compressionAlgorithm = compressionAlgorithm;
            this.region = region;
        }

        public String getMetaName() {
            return this.metaName;
        }

        public CompressionAlgorithm getCompressionAlgorithm() {
            return this.compressionAlgorithm;
        }

        public BlockRegion getRegion() {
            return this.region;
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeString(out, defaultPrefix + this.metaName);
            Utils.writeString(out, this.compressionAlgorithm.getName());
            this.region.write(out);
        }
    }

    static class MetaIndex {
        final Map<String, MetaIndexEntry> index;

        public MetaIndex() {
            this.index = new TreeMap<String, MetaIndexEntry>();
        }

        public MetaIndex(DataInput in) throws IOException {
            int count = Utils.readVInt(in);
            this.index = new TreeMap<String, MetaIndexEntry>();
            for (int nx = 0; nx < count; ++nx) {
                MetaIndexEntry indexEntry = new MetaIndexEntry(in);
                this.index.put(indexEntry.getMetaName(), indexEntry);
            }
        }

        public void addEntry(MetaIndexEntry indexEntry) {
            this.index.put(indexEntry.getMetaName(), indexEntry);
        }

        public MetaIndexEntry getMetaByName(String name) {
            return this.index.get(name);
        }

        public void write(DataOutput out) throws IOException {
            Utils.writeVInt(out, this.index.size());
            for (MetaIndexEntry indexEntry : this.index.values()) {
                indexEntry.write(out);
            }
        }
    }

    public static class Reader
    implements Closeable {
        private final SeekableDataInputStream in;
        private final Configuration conf;
        final DataIndex dataIndex;
        final MetaIndex metaIndex;
        final Utils.Version version;
        private byte[] decryptionParams;
        private FileDecrypter decrypter;

        public byte[] serializeMetadata(int maxSize) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(baos);
                this.metaIndex.write(out);
                if (out.size() > maxSize) {
                    return null;
                }
                this.dataIndex.write(out);
                if (out.size() > maxSize) {
                    return null;
                }
                CryptoUtils.writeParams(this.decryptionParams, out);
                if (out.size() > maxSize) {
                    return null;
                }
                out.close();
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public <InputStreamType extends InputStream> Reader(InputStreamType fin, long fileLength, Configuration conf, CryptoService cryptoService) throws IOException {
            this.in = new SeekableDataInputStream(fin);
            this.conf = conf;
            this.in.seek(fileLength - (long)Magic.size() - (long)Utils.Version.size());
            this.version = new Utils.Version(this.in);
            Magic.readAndVerify(this.in);
            if (!this.version.compatibleWith(API_VERSION_3) && !this.version.compatibleWith(API_VERSION_1)) {
                throw new IOException("Unsupported BCFile Version found: " + this.version + ". Only support " + API_VERSION_1 + " or " + API_VERSION_3);
            }
            long offsetIndexMeta = 0L;
            long offsetCryptoParameters = 0L;
            if (this.version.equals(API_VERSION_1)) {
                this.in.seek(fileLength - (long)Magic.size() - (long)Utils.Version.size() - 8L);
                offsetIndexMeta = this.in.readLong();
            } else {
                this.in.seek(fileLength - (long)Magic.size() - (long)Utils.Version.size() - 16L);
                offsetIndexMeta = this.in.readLong();
                offsetCryptoParameters = this.in.readLong();
            }
            this.in.seek(offsetIndexMeta);
            this.metaIndex = new MetaIndex(this.in);
            CryptoEnvironmentImpl cryptoEnvironment = null;
            if (this.version.equals(API_VERSION_1)) {
                LOG.trace((Object)"Found a version 1 file to read.");
                this.decryptionParams = new NoFileEncrypter().getDecryptionParameters();
                this.decrypter = new NoFileDecrypter();
            } else {
                this.in.seek(offsetCryptoParameters);
                this.decryptionParams = CryptoUtils.readParams(this.in);
                cryptoEnvironment = new CryptoEnvironmentImpl(CryptoEnvironment.Scope.TABLE, null, this.decryptionParams);
                this.decrypter = cryptoService.getFileDecrypter(cryptoEnvironment);
            }
            try (BlockReader blockR = this.getMetaBlock("BCFile.index");){
                this.dataIndex = new DataIndex(blockR);
            }
        }

        public <InputStreamType extends InputStream> Reader(byte[] serializedMetadata, InputStreamType fin, Configuration conf, CryptoService cryptoService) throws IOException {
            this.in = new SeekableDataInputStream(fin);
            this.conf = conf;
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedMetadata);
            DataInputStream dis = new DataInputStream(bais);
            this.version = null;
            this.metaIndex = new MetaIndex(dis);
            this.dataIndex = new DataIndex(dis);
            this.decryptionParams = CryptoUtils.readParams(dis);
            CryptoEnvironmentImpl env = new CryptoEnvironmentImpl(CryptoEnvironment.Scope.TABLE, null, this.decryptionParams);
            this.decrypter = cryptoService.getFileDecrypter(env);
        }

        @Override
        public void close() {
        }

        public int getBlockCount() {
            return this.dataIndex.getBlockRegionList().size();
        }

        public BlockReader getMetaBlock(String name) throws IOException, MetaBlockDoesNotExist {
            MetaIndexEntry imeBCIndex = this.metaIndex.getMetaByName(name);
            if (imeBCIndex == null) {
                throw new MetaBlockDoesNotExist("name=" + name);
            }
            BlockRegion region = imeBCIndex.getRegion();
            return this.createReader(imeBCIndex.getCompressionAlgorithm(), region);
        }

        public long getMetaBlockRawSize(String name) throws IOException, MetaBlockDoesNotExist {
            MetaIndexEntry imeBCIndex = this.metaIndex.getMetaByName(name);
            if (imeBCIndex == null) {
                throw new MetaBlockDoesNotExist("name=" + name);
            }
            return imeBCIndex.getRegion().getRawSize();
        }

        public BlockReader getDataBlock(int blockIndex) throws IOException {
            if (blockIndex < 0 || blockIndex >= this.getBlockCount()) {
                throw new IndexOutOfBoundsException(String.format("blockIndex=%d, numBlocks=%d", blockIndex, this.getBlockCount()));
            }
            BlockRegion region = this.dataIndex.getBlockRegionList().get(blockIndex);
            return this.createReader(this.dataIndex.getDefaultCompressionAlgorithm(), region);
        }

        public BlockReader getDataBlock(long offset, long compressedSize, long rawSize) throws IOException {
            BlockRegion region = new BlockRegion(offset, compressedSize, rawSize);
            return this.createReader(this.dataIndex.getDefaultCompressionAlgorithm(), region);
        }

        public long getDataBlockRawSize(int blockIndex) {
            if (blockIndex < 0 || blockIndex >= this.getBlockCount()) {
                throw new IndexOutOfBoundsException(String.format("blockIndex=%d, numBlocks=%d", blockIndex, this.getBlockCount()));
            }
            return this.dataIndex.getBlockRegionList().get(blockIndex).getRawSize();
        }

        private BlockReader createReader(CompressionAlgorithm compressAlgo, BlockRegion region) throws IOException {
            RBlockState rbs = new RBlockState(compressAlgo, this.in, region, this.conf, this.decrypter);
            return new BlockReader(rbs);
        }

        public static class BlockReader
        extends DataInputStream {
            private final RBlockState rBlkState;
            private boolean closed = false;

            BlockReader(RBlockState rbs) {
                super(rbs.getInputStream());
                this.rBlkState = rbs;
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                try {
                    this.rBlkState.finish();
                }
                finally {
                    this.closed = true;
                }
            }

            public long getRawSize() {
                return this.rBlkState.getBlockRegion().getRawSize();
            }
        }

        private static final class RBlockState {
            private final CompressionAlgorithm compressAlgo;
            private Decompressor decompressor;
            private final BlockRegion region;
            private final InputStream in;
            private volatile boolean closed;

            public <InputStreamType extends InputStream> RBlockState(CompressionAlgorithm compressionAlgo, InputStreamType fsin, BlockRegion region, Configuration conf, FileDecrypter decrypter) throws IOException {
                this.compressAlgo = compressionAlgo;
                this.region = region;
                this.decompressor = compressionAlgo.getDecompressor();
                BoundedRangeFileInputStream boundedRangeFileInputStream = new BoundedRangeFileInputStream(fsin, this.region.getOffset(), this.region.getCompressedSize());
                try {
                    InputStream inputStreamToBeCompressed = decrypter.decryptStream(boundedRangeFileInputStream);
                    this.in = this.compressAlgo.createDecompressionStream(inputStreamToBeCompressed, this.decompressor, BCFile.getFSInputBufferSize(conf));
                }
                catch (IOException e) {
                    this.compressAlgo.returnDecompressor(this.decompressor);
                    throw e;
                }
                this.closed = false;
            }

            public InputStream getInputStream() {
                return this.in;
            }

            public BlockRegion getBlockRegion() {
                return this.region;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finish() throws IOException {
                InputStream inputStream = this.in;
                synchronized (inputStream) {
                    if (!this.closed) {
                        try {
                            this.in.close();
                        }
                        finally {
                            this.closed = true;
                            if (this.decompressor != null) {
                                try {
                                    this.compressAlgo.returnDecompressor(this.decompressor);
                                }
                                finally {
                                    this.decompressor = null;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static class Writer
    implements Closeable {
        private final RateLimitedOutputStream out;
        private final Configuration conf;
        private FileEncrypter encrypter;
        private CryptoEnvironmentImpl cryptoEnvironment;
        final DataIndex dataIndex;
        final MetaIndex metaIndex;
        boolean blkInProgress = false;
        private boolean metaBlkSeen = false;
        private boolean closed = false;
        long errorCount = 0L;
        private BytesWritable fsOutputBuffer;
        private long length = 0L;

        public long getLength() {
            return this.length;
        }

        public Writer(FSDataOutputStream fout, RateLimiter writeLimiter, String compressionName, Configuration conf, CryptoService cryptoService) throws IOException {
            if (fout.getPos() != 0L) {
                throw new IOException("Output file not at zero offset.");
            }
            this.out = new RateLimitedOutputStream(fout, writeLimiter);
            this.conf = conf;
            this.dataIndex = new DataIndex(compressionName);
            this.metaIndex = new MetaIndex();
            this.fsOutputBuffer = new BytesWritable();
            Magic.write(this.out);
            this.cryptoEnvironment = new CryptoEnvironmentImpl(CryptoEnvironment.Scope.TABLE, null, null);
            this.encrypter = cryptoService.getFileEncrypter(this.cryptoEnvironment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            block11: {
                if (this.closed) {
                    return;
                }
                try {
                    if (this.errorCount != 0L) break block11;
                    if (this.blkInProgress) {
                        throw new IllegalStateException("Close() called with active block appender.");
                    }
                    try (BlockAppender appender = this.prepareMetaBlock("BCFile.index", this.getDefaultCompressionAlgorithm());){
                        this.dataIndex.write(appender);
                    }
                    long offsetIndexMeta = this.out.position();
                    this.metaIndex.write(this.out);
                    long offsetCryptoParameter = this.out.position();
                    byte[] cryptoParams = this.encrypter.getDecryptionParameters();
                    this.out.writeInt(cryptoParams.length);
                    this.out.write(cryptoParams);
                    this.out.writeLong(offsetIndexMeta);
                    this.out.writeLong(offsetCryptoParameter);
                    API_VERSION_3.write(this.out);
                    Magic.write(this.out);
                    this.out.flush();
                    this.length = this.out.position();
                    this.out.close();
                }
                finally {
                    this.closed = true;
                }
            }
        }

        private CompressionAlgorithm getDefaultCompressionAlgorithm() {
            return this.dataIndex.getDefaultCompressionAlgorithm();
        }

        private BlockAppender prepareMetaBlock(String name, CompressionAlgorithm compressAlgo) throws IOException, MetaBlockAlreadyExists {
            if (this.blkInProgress) {
                throw new IllegalStateException("Cannot create Meta Block until previous block is closed.");
            }
            if (this.metaIndex.getMetaByName(name) != null) {
                throw new MetaBlockAlreadyExists("name=" + name);
            }
            MetaBlockRegister mbr = new MetaBlockRegister(name, compressAlgo);
            WBlockState wbs = new WBlockState(compressAlgo, this.out, this.fsOutputBuffer, this.conf, this.encrypter);
            BlockAppender ba = new BlockAppender(mbr, wbs);
            this.blkInProgress = true;
            this.metaBlkSeen = true;
            return ba;
        }

        public BlockAppender prepareMetaBlock(String name) throws IOException, MetaBlockAlreadyExists {
            return this.prepareMetaBlock(name, this.getDefaultCompressionAlgorithm());
        }

        public BlockAppender prepareDataBlock() throws IOException {
            if (this.blkInProgress) {
                throw new IllegalStateException("Cannot create Data Block until previous block is closed.");
            }
            if (this.metaBlkSeen) {
                throw new IllegalStateException("Cannot create Data Block after Meta Blocks.");
            }
            WBlockState wbs = new WBlockState(this.getDefaultCompressionAlgorithm(), this.out, this.fsOutputBuffer, this.conf, this.encrypter);
            BlockAppender ba = new BlockAppender(wbs);
            this.blkInProgress = true;
            return ba;
        }

        private class MetaBlockRegister {
            private final String name;
            private final CompressionAlgorithm compressAlgo;

            MetaBlockRegister(String name, CompressionAlgorithm compressAlgo) {
                this.name = name;
                this.compressAlgo = compressAlgo;
            }

            public void register(long raw, long begin, long end) {
                Writer.this.metaIndex.addEntry(new MetaIndexEntry(this.name, this.compressAlgo, new BlockRegion(begin, end - begin, raw)));
            }
        }

        public class BlockAppender
        extends DataOutputStream {
            private final MetaBlockRegister metaBlockRegister;
            private final WBlockState wBlkState;
            private boolean closed;

            BlockAppender(MetaBlockRegister metaBlockRegister, WBlockState wbs) {
                super(wbs.getOutputStream());
                this.closed = false;
                this.metaBlockRegister = metaBlockRegister;
                this.wBlkState = wbs;
            }

            BlockAppender(WBlockState wbs) {
                super(wbs.getOutputStream());
                this.closed = false;
                this.metaBlockRegister = null;
                this.wBlkState = wbs;
            }

            public long getRawSize() {
                return (long)this.size() & 0xFFFFFFFFL;
            }

            public long getCompressedSize() throws IOException {
                return this.wBlkState.getCompressedSize();
            }

            public long getStartPos() {
                return this.wBlkState.getStartPos();
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                try {
                    ++Writer.this.errorCount;
                    this.wBlkState.finish();
                    if (this.metaBlockRegister != null) {
                        this.metaBlockRegister.register(this.getRawSize(), this.wBlkState.getStartPos(), this.wBlkState.getCurrentPos());
                    }
                    --Writer.this.errorCount;
                }
                finally {
                    this.closed = true;
                    Writer.this.blkInProgress = false;
                }
            }
        }

        private static final class WBlockState {
            private final CompressionAlgorithm compressAlgo;
            private Compressor compressor;
            private final RateLimitedOutputStream fsOut;
            private final OutputStream cipherOut;
            private final long posStart;
            private final SimpleBufferedOutputStream fsBufferedOutput;
            private OutputStream out;

            public WBlockState(CompressionAlgorithm compressionAlgo, RateLimitedOutputStream fsOut, BytesWritable fsOutputBuffer, Configuration conf, FileEncrypter encrypter) throws IOException {
                this.compressAlgo = compressionAlgo;
                this.fsOut = fsOut;
                this.posStart = fsOut.position();
                fsOutputBuffer.setCapacity(BCFile.getFSOutputBufferSize(conf));
                this.fsBufferedOutput = new SimpleBufferedOutputStream(this.fsOut, fsOutputBuffer.getBytes());
                this.compressor = this.compressAlgo.getCompressor();
                try {
                    this.cipherOut = encrypter.encryptStream(this.fsBufferedOutput);
                    this.out = compressionAlgo.createCompressionStream(this.cipherOut, this.compressor, 0);
                }
                catch (IOException e) {
                    this.compressAlgo.returnCompressor(this.compressor);
                    throw e;
                }
            }

            OutputStream getOutputStream() {
                return this.out;
            }

            long getCurrentPos() {
                return this.fsOut.position() + (long)this.fsBufferedOutput.size();
            }

            long getStartPos() {
                return this.posStart;
            }

            long getCompressedSize() {
                return this.getCurrentPos() - this.posStart;
            }

            public void finish() throws IOException {
                try {
                    if (this.out != null) {
                        this.out.flush();
                        if (this.fsBufferedOutput != this.cipherOut) {
                            this.cipherOut.close();
                        }
                        this.out = null;
                    }
                }
                finally {
                    this.compressAlgo.returnCompressor(this.compressor);
                    this.compressor = null;
                }
            }
        }
    }
}

