/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.accumulo.core.manager.thrift.BulkImportState;
import org.apache.accumulo.core.manager.thrift.BulkImportStatus;

public class ServerBulkImportStatus {
    private final ConcurrentMap<String, BulkImportStatus> status = new ConcurrentHashMap<String, BulkImportStatus>();

    public List<BulkImportStatus> getBulkLoadStatus() {
        return new ArrayList<BulkImportStatus>(this.status.values());
    }

    public void updateBulkImportStatus(List<String> files, BulkImportState state) {
        for (String file : files) {
            this.status.compute(file, (key, currentStatus) -> {
                if (currentStatus == null) {
                    return new BulkImportStatus(System.currentTimeMillis(), file, state);
                }
                currentStatus.state = state;
                return currentStatus;
            });
        }
    }

    public void removeBulkImportStatus(List<String> files) {
        this.status.keySet().removeAll(files);
    }
}

