/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import java.util.Properties;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.rpc.SaslConnectionParams;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;

public class SaslServerConnectionParams
extends SaslConnectionParams {
    private AuthenticationTokenSecretManager secretManager;

    public SaslServerConnectionParams(AccumuloConfiguration conf, AuthenticationToken token) {
        this(conf, token, null);
    }

    public SaslServerConnectionParams(AccumuloConfiguration conf, AuthenticationToken token, AuthenticationTokenSecretManager secretManager) {
        super(conf, token);
        this.setSecretManager(secretManager);
    }

    public SaslServerConnectionParams(Properties clientProps, AuthenticationToken token, AuthenticationTokenSecretManager secretManager) {
        super(clientProps, token);
        this.setSecretManager(secretManager);
    }

    protected void updateFromToken(AuthenticationToken token) {
        if (!(token instanceof KerberosToken) && !(token instanceof SystemCredentials.SystemToken)) {
            throw new IllegalArgumentException("Cannot determine SASL mechanism for token class: " + String.valueOf(token.getClass()));
        }
        this.mechanism = SaslConnectionParams.SaslMechanism.GSSAPI;
    }

    public AuthenticationTokenSecretManager getSecretManager() {
        return this.secretManager;
    }

    public void setSecretManager(AuthenticationTokenSecretManager secretManager) {
        this.secretManager = secretManager;
    }
}

